/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfig;
import apoc.ExtendedApocConfig;
import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;

public class UriResolver {
    private URI uri;
    private String url;
    private String prefix;
    private AuthToken token;

    public UriResolver(String url, String prefix) throws URISyntaxException {
        this.url = url;
        this.prefix = prefix;
    }

    public URI getConfiguredUri() {
        return this.uri;
    }

    public AuthToken getToken() {
        return this.token;
    }

    private String getConfiguredUri(String key) {
        String keyUrl = "apoc." + this.prefix + "." + key + ".url";
        if (ExtendedApocConfig.extendedApocConfig().containsKey("apoc.bolt.url")) {
            key = ApocConfig.apocConfig().getString("apoc.bolt.url");
        } else if (ExtendedApocConfig.extendedApocConfig().containsKey(keyUrl)) {
            key = ApocConfig.apocConfig().getString(keyUrl, key);
        }
        return key;
    }

    public void initialize() throws URISyntaxException {
        URI uri;
        this.url = this.getConfiguredUri(this.url);
        try {
            uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            throw new URISyntaxException(e.getInput(), e.getMessage());
        }
        this.uri = uri;
        String[] userInfoArray = uri.getUserInfo() == null ? new String[2] : uri.getUserInfo().split(":");
        String user = userInfoArray[0];
        String password = userInfoArray[1];
        if (user != null && password == null || user == null && password != null) {
            throw new RuntimeException("user and password don't defined check your URL or if you use a key the property in your apoc.conf file");
        }
        this.token = user != null && password != null ? AuthTokens.basic((String)user, (String)password) : AuthTokens.none();
    }
}

