/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.ApocConfig;
import apoc.ExtendedSystemLabels;
import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.util.SystemDbUtil;
import apoc.util.Util;
import apoc.uuid.UuidConfig;
import apoc.uuid.UuidInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;

public class UUIDHandlerNewProcedures {
    public static boolean isEnabled(String databaseName) {
        String apocUUIDEnabledDb = String.format("apoc.uuid.enabled.%s", databaseName);
        Configuration conf = ApocConfig.apocConfig().getConfig();
        boolean enabled = conf.getBoolean("apoc.uuid.enabled", false);
        return conf.getBoolean(apocUUIDEnabledDb, enabled);
    }

    public static void checkEnabled(String databaseName) {
        if (!UUIDHandlerNewProcedures.isEnabled(databaseName)) {
            String error = String.format("UUID have not been enabled. Set 'apoc.uuid.enabled=true' or 'apoc.uuid.enabled.%s=true' in your apoc.conf file located in the $NEO4J_HOME/conf/ directory.", databaseName);
            throw new RuntimeException(error);
        }
    }

    public static UuidInfo create(String databaseName, String label, UuidConfig config) {
        UuidInfo[] result = new UuidInfo[1];
        SystemDbUtil.withSystemDb(sysTx -> {
            Node node = Util.mergeNode((Transaction)sysTx, (Label)ExtendedSystemLabels.ApocUuid, null, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)databaseName), Pair.of((Object)ExtendedSystemPropertyKeys.label.name(), (Object)label)});
            node.setProperty(ExtendedSystemPropertyKeys.propertyName.name(), (Object)config.getUuidProperty());
            node.setProperty(ExtendedSystemPropertyKeys.addToSetLabel.name(), (Object)config.isAddToSetLabels());
            node.setProperty(ExtendedSystemPropertyKeys.addToExistingNodes.name(), (Object)config.isAddToExistingNodes());
            result[0] = new UuidInfo(node, true);
            SystemDbUtil.setLastUpdate(sysTx, databaseName, ExtendedSystemLabels.ApocUuidMeta);
        });
        return result[0];
    }

    public static UuidInfo drop(String databaseName, String labelName) {
        return SystemDbUtil.withSystemDb(tx -> {
            UuidInfo uuidInfo = UUIDHandlerNewProcedures.getUuidNodes(tx, databaseName, Map.of(ExtendedSystemPropertyKeys.label.name(), labelName)).stream().map(node -> {
                UuidInfo info = new UuidInfo((Node)node);
                node.delete();
                return info;
            }).findAny().orElse(null);
            SystemDbUtil.setLastUpdate(tx, databaseName, ExtendedSystemLabels.ApocUuidMeta);
            return uuidInfo;
        });
    }

    public static List<UuidInfo> dropAll(String databaseName) {
        return SystemDbUtil.withSystemDb(tx -> {
            List previous = UUIDHandlerNewProcedures.getUuidNodes(tx, databaseName).stream().map(node -> {
                UuidInfo info = new UuidInfo((Node)node);
                node.delete();
                return info;
            }).collect(Collectors.toList());
            SystemDbUtil.setLastUpdate(tx, databaseName, ExtendedSystemLabels.ApocUuidMeta);
            return previous;
        });
    }

    public static ResourceIterator<Node> getUuidNodes(Transaction tx, String databaseName) {
        return UUIDHandlerNewProcedures.getUuidNodes(tx, databaseName, null);
    }

    public static ResourceIterator<Node> getUuidNodes(Transaction tx, String databaseName, Map<String, Object> props) {
        return SystemDbUtil.getSystemNodes(tx, databaseName, ExtendedSystemLabels.ApocUuid, props);
    }
}

