/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.Extended;
import apoc.ml.RestAPIConfig;
import apoc.result.ListResult;
import apoc.result.MapResult;
import apoc.util.CollectionUtils;
import apoc.util.ExtendedUtil;
import apoc.util.MapUtil;
import apoc.vectordb.VectorDb;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class ChromaDb {
    public static final VectorDbHandler DB_HANDLER = VectorDbHandler.Type.CHROMA.get();
    @Context
    public ProcedureCallContext procedureCallContext;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.vectordb.chroma.info")
    @Description(value="apoc.vectordb.chroma.info(hostOrKey, collection, $configuration) - Get information about the specified existing collection or throws an error if it does not exist")
    public Stream<MapResult> info(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorDbUtil.methodAndPayloadNull(config);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), Map.of());
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.chroma.createCollection")
    @Description(value="apoc.vectordb.chroma.createCollection(hostOrKey, collection, similarity, size, $configuration) - Creates a collection, with the name specified in the 2nd parameter, and with the specified `similarity` and `size`")
    public Stream<MapResult> createCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="similarity") String similarity, @Name(value="size") Long size, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "POST");
        Map<String, Long> metadata = Map.of("hnsw:space", similarity, "size", size);
        Map<String, Map<String, Long>> additionalBodies = Map.of("name", collection, "metadata", metadata);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.chroma.deleteCollection")
    @Description(value="apoc.vectordb.chroma.deleteCollection(hostOrKey, collection, $configuration) - Deletes a collection with the name specified in the 2nd parameter")
    public Stream<MapResult> deleteCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "DELETE");
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), Map.of());
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.chroma.upsert")
    @Description(value="apoc.vectordb.chroma.upsert(hostOrKey, collection, vectors, $configuration) - Upserts, in the collection with the name specified in the 2nd parameter, the vectors [{id: 'id', vector: '<vectorDb>', medatada: '<metadata>'}]")
    public Stream<MapResult> upsert(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vectors") List<Map<String, Object>> vectors, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections/%s/upsert";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        Map<String, String> mapKeys = Map.of("id", "ids", "vector", "embeddings", "metadata", "metadatas", "text", "documents");
        Map<Object, List> additionalBodies = ExtendedUtil.listOfMapToMapOfLists(mapKeys, vectors);
        additionalBodies.compute("ids", (k, v) -> this.getStringIds((List<Object>)v));
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.chroma.delete")
    @Description(value="apoc.vectordb.chroma.delete(hostOrKey, collection, ids, $configuration) - Deletes the vectors with the specified `ids`")
    public Stream<ListResult> delete(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections/%s/delete";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromGet(config, this.procedureCallContext, this.getStringIds(ids), collection);
        return VectorDb.executeRequest(conf.getApiConfig(), this.urlAccessChecker).map(v -> (List)v).map(ListResult::new);
    }

    @Procedure(value="apoc.vectordb.chroma.get")
    @Description(value="apoc.vectordb.chroma.get(hostOrKey, collection, ids, $configuration) - Gets the vectors with the specified `ids`")
    public Stream<VectorDbUtil.EmbeddingResult> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.getCommon(hostOrKey, collection, ids, configuration);
    }

    @Procedure(value="apoc.vectordb.chroma.getAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.chroma.getAndUpdate(hostOrKey, collection, ids, $configuration) - Gets the vectors with the specified `ids`, and optionally creates/updates neo4j entities")
    public Stream<VectorDbUtil.EmbeddingResult> getAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.getCommon(hostOrKey, collection, ids, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> getCommon(String hostOrKey, String collection, List<Object> ids, Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections/%s/get";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig apiConfig = DB_HANDLER.getEmbedding().fromGet(config, this.procedureCallContext, ids, collection);
        return VectorDb.getEmbeddingResultStream(apiConfig, this.procedureCallContext, this.urlAccessChecker, this.tx, v -> ChromaDb.listToMap((Map)v).stream());
    }

    @Procedure(value="apoc.vectordb.chroma.query")
    @Description(value="apoc.vectordb.chroma.query(hostOrKey, collection, vector, filter, limit, $configuration) - Retrieves closest vectors from the defined `vector`, `limit` of results, in the collection with the name specified in the 2nd parameter")
    public Stream<VectorDbUtil.EmbeddingResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="{}") Map<String, Object> filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.queryCommon(hostOrKey, collection, vector, filter, limit, configuration);
    }

    @Procedure(value="apoc.vectordb.chroma.queryAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.chroma.queryAndUpdate(hostOrKey, collection, vector, filter, limit, $configuration) - Retrieves closest vectors from the defined `vector`, `limit` of results, in the collection with the name specified in the 2nd parameter, and optionally creates/updates neo4j entities")
    public Stream<VectorDbUtil.EmbeddingResult> queryAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="{}") Map<String, Object> filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.queryCommon(hostOrKey, collection, vector, filter, limit, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> queryCommon(String hostOrKey, String collection, List<Double> vector, Map<String, Object> filter, long limit, Map<String, Object> configuration) throws Exception {
        String url = "%s/api/v1/collections/%s/query";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromQuery(config, this.procedureCallContext, vector, filter, limit, collection);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx, v -> ChromaDb.listOfListsToMap((Map)v).stream());
    }

    private Map<String, Object> getVectorDbInfo(String hostOrKey, String collection, Map<String, Object> configuration, String templateUrl) {
        return VectorDbUtil.getCommonVectorDbInfo(hostOrKey, collection, configuration, templateUrl, DB_HANDLER);
    }

    private static List<Map> listOfListsToMap(Map startMap) {
        List distances = startMap.get("distances") == null ? null : (List)((List)startMap.get("distances")).get(0);
        List metadatas = startMap.get("metadatas") == null ? null : (List)((List)startMap.get("metadatas")).get(0);
        List documents = startMap.get("documents") == null ? null : (List)((List)startMap.get("documents")).get(0);
        List embeddings = startMap.get("embeddings") == null ? null : (List)((List)startMap.get("embeddings")).get(0);
        List ids = (List)((List)startMap.get("ids")).get(0);
        return ChromaDb.getMaps(distances, metadatas, documents, embeddings, ids);
    }

    private static List<Map> listToMap(Map startMap) {
        List distances = (List)startMap.get("distances");
        List metadatas = (List)startMap.get("metadatas");
        List documents = (List)startMap.get("documents");
        List embeddings = (List)startMap.get("embeddings");
        List ids = (List)startMap.get("ids");
        return ChromaDb.getMaps(distances, metadatas, documents, embeddings, ids);
    }

    private static List<Map> getMaps(List distances, List metadatas, List documents, List embeddings, List ids) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (int i = 0; i < ids.size(); ++i) {
            Map map = MapUtil.map((Object[])new Object[]{"id", ids.get(i)});
            if (CollectionUtils.isNotEmpty((Collection)distances)) {
                map.put("score", distances.get(i));
            }
            if (CollectionUtils.isNotEmpty((Collection)metadatas)) {
                map.put("metadata", metadatas.get(i));
            }
            if (CollectionUtils.isNotEmpty((Collection)documents)) {
                map.put("text", documents.get(i));
            }
            if (CollectionUtils.isNotEmpty((Collection)embeddings)) {
                map.put("vector", embeddings.get(i));
            }
            result.add(map);
        }
        return result;
    }

    private List<String> getStringIds(List<Object> ids) {
        return ids.stream().map(Object::toString).toList();
    }
}

