/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.util.MapUtil;
import apoc.util.UrlResolver;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorEmbeddingConfig;
import apoc.vectordb.VectorEmbeddingHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public class ChromaHandler
implements VectorDbHandler {
    @Override
    public String getUrl(String hostOrKey) {
        return new UrlResolver("http", "localhost", 8000).getUrl("chroma", hostOrKey);
    }

    @Override
    public VectorEmbeddingHandler getEmbedding() {
        return new ChromaEmbeddingHandler();
    }

    @Override
    public String getLabel() {
        return "Chroma";
    }

    static class ChromaEmbeddingHandler
    implements VectorEmbeddingHandler {
        ChromaEmbeddingHandler() {
        }

        @Override
        public <T> VectorEmbeddingConfig fromGet(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<T> ids, String collection) {
            List<String> fields = procedureCallContext.outputFields().toList();
            VectorEmbeddingConfig conf = new VectorEmbeddingConfig(config);
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"ids", ids});
            return this.getVectorEmbeddingConfig(conf, fields, additionalBodies);
        }

        @Override
        public VectorEmbeddingConfig fromQuery(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<Double> vector, Object filter, long limit, String collection) {
            List<String> fields = procedureCallContext.outputFields().toList();
            VectorEmbeddingConfig conf = new VectorEmbeddingConfig(config);
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"query_embeddings", List.of(vector), "where", filter, "n_results", limit});
            return this.getVectorEmbeddingConfig(conf, fields, additionalBodies);
        }

        private VectorEmbeddingConfig getVectorEmbeddingConfig(VectorEmbeddingConfig config, List<String> fields, Map<String, Object> additionalBodies) {
            ArrayList<String> include = new ArrayList<String>();
            if (fields.contains("metadata")) {
                include.add("metadatas");
            }
            if (fields.contains("text") && config.isAllResults()) {
                include.add("documents");
            }
            if (fields.contains("vector") && config.isAllResults()) {
                include.add("embeddings");
            }
            if (fields.contains("score")) {
                include.add("distances");
            }
            additionalBodies.put("include", include);
            return this.populateApiBodyRequest(config, additionalBodies);
        }
    }
}

