/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.Extended;
import apoc.ml.RestAPIConfig;
import apoc.result.MapResult;
import apoc.vectordb.VectorDb;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Pinecone {
    public static final VectorDbHandler DB_HANDLER = VectorDbHandler.Type.PINECONE.get();
    @Context
    public ProcedureCallContext procedureCallContext;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.vectordb.pinecone.info")
    @Description(value="apoc.vectordb.pinecone.info(hostOrKey, index, $configuration) - Get information about the specified existing index or throws an error if it does not exist")
    public Stream<MapResult> getInfo(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/indexes/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        VectorDbUtil.methodAndPayloadNull(config);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), Map.of());
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.pinecone.createCollection")
    @Description(value="apoc.vectordb.pinecone.createCollection(hostOrKey, index, similarity, size, $configuration) - Creates a index, with the name specified in the 2nd parameter, and with the specified `similarity` and `size`")
    public Stream<MapResult> createCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="similarity") String similarity, @Name(value="size") Long size, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/indexes";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        config.putIfAbsent("method", "POST");
        Map<String, String> additionalBodies = Map.of("name", index, "dimension", size, "metric", similarity);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.pinecone.deleteCollection")
    @Description(value="apoc.vectordb.pinecone.deleteCollection(hostOrKey, index, $configuration) - Deletes a index with the name specified in the 2nd parameter")
    public Stream<MapResult> deleteCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/indexes/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        config.putIfAbsent("method", "DELETE");
        RestAPIConfig restAPIConfig = new RestAPIConfig(config);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.pinecone.upsert")
    @Description(value="apoc.vectordb.pinecone.upsert(hostOrKey, index, vectors, $configuration) - Upserts, in the index with the name specified in the 2nd parameter, the vectors [{id: 'id', vector: '<vectorDb>', medatada: '<metadata>'}]")
    public Stream<MapResult> upsert(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="vectors") List<Map<String, Object>> vectors, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/vectors/upsert";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        config.putIfAbsent("method", "POST");
        vectors = vectors.stream().map(i -> {
            HashMap map = new HashMap(i);
            map.putIfAbsent("values", map.remove("vector"));
            return map;
        }).toList();
        Map<String, List<Map<String, Object>>> additionalBodies = Map.of("vectors", vectors);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.pinecone.delete")
    @Description(value="apoc.vectordb.pinecone.delete(hostOrKey, index, ids, $configuration) - Delete the vectors with the specified `ids`")
    public Stream<MapResult> delete(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="vectors") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/vectors/delete";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        config.putIfAbsent("method", "POST");
        Map<String, List<Object>> additionalBodies = Map.of("ids", ids);
        RestAPIConfig apiConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(apiConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.pinecone.get")
    @Description(value="apoc.vectordb.pinecone.get(hostOrKey, index, ids, $configuration) - Get the vectors with the specified `ids`")
    public Stream<VectorDbUtil.EmbeddingResult> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.getCommon(hostOrKey, index, ids, configuration);
    }

    @Procedure(value="apoc.vectordb.pinecone.getAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.pinecone.getAndUpdate(hostOrKey, index, ids, $configuration) - Get the vectors with the specified `ids`")
    public Stream<VectorDbUtil.EmbeddingResult> getAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.getCommon(hostOrKey, index, ids, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> getCommon(String hostOrKey, String index, List<Object> ids, Map<String, Object> configuration) throws Exception {
        String url = "%s/vectors/fetch";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromGet(config, this.procedureCallContext, ids, index);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx, v -> {
            Object vectors = ((Map)v).get("vectors");
            return ((Map)vectors).values().stream();
        });
    }

    @Procedure(value="apoc.vectordb.pinecone.query")
    @Description(value="apoc.vectordb.pinecone.query(hostOrKey, index, vector, filter, limit, $configuration) - Retrieve closest vectors the the defined `vector`, `limit` of results,  in the index with the name specified in the 2nd parameter")
    public Stream<VectorDbUtil.EmbeddingResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="{}") Map<String, Object> filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.queryCommon(hostOrKey, index, vector, filter, limit, configuration);
    }

    @Procedure(value="apoc.vectordb.pinecone.queryAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.pinecone.queryAndUpdate(hostOrKey, index, vector, filter, limit, $configuration) - Retrieve closest vectors the the defined `vector`, `limit` of results,  in the index with the name specified in the 2nd parameter")
    public Stream<VectorDbUtil.EmbeddingResult> queryAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="index") String index, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="{}") Map<String, Object> filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.queryCommon(hostOrKey, index, vector, filter, limit, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> queryCommon(String hostOrKey, String index, List<Double> vector, Map<String, Object> filter, long limit, Map<String, Object> configuration) throws Exception {
        String url = "%s/query";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, index, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromQuery(config, this.procedureCallContext, vector, filter, limit, index);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx, v -> {
            Map map = (Map)v;
            return ((List)map.get("matches")).stream();
        });
    }

    private Map<String, Object> getVectorDbInfo(String hostOrKey, String index, Map<String, Object> configuration, String templateUrl) {
        return VectorDbUtil.getCommonVectorDbInfo(hostOrKey, index, configuration, templateUrl, DB_HANDLER);
    }
}

