/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.Extended;
import apoc.ml.RestAPIConfig;
import apoc.result.MapResult;
import apoc.vectordb.VectorDb;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Qdrant {
    public static final VectorDbHandler DB_HANDLER = VectorDbHandler.Type.QDRANT.get();
    @Context
    public ProcedureCallContext procedureCallContext;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.vectordb.qdrant.info")
    @Description(value="apoc.vectordb.qdrant.info(hostOrKey, collection, $configuration) - Get information about the specified existing collection or throws an error if it does not exist")
    public Stream<MapResult> info(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorDbUtil.methodAndPayloadNull(config);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), Map.of());
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.qdrant.createCollection")
    @Description(value="apoc.vectordb.qdrant.createCollection(hostOrKey, collection, similarity, size, $configuration) - Creates a collection, with the name specified in the 2nd parameter, and with the specified `similarity` and `size`")
    public Stream<MapResult> createCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="similarity") String similarity, @Name(value="size") Long size, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "PUT");
        Map<String, Map<String, String>> additionalBodies = Map.of("vectors", Map.of("size", size, "distance", similarity));
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.qdrant.deleteCollection")
    @Description(value="apoc.vectordb.qdrant.deleteCollection(hostOrKey, collection, $configuration) - Deletes a collection with the name specified in the 2nd parameter")
    public Stream<MapResult> deleteCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "DELETE");
        RestAPIConfig restAPIConfig = new RestAPIConfig(config);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.qdrant.upsert")
    @Description(value="apoc.vectordb.qdrant.upsert(hostOrKey, collection, vectors, $configuration) - Upserts, in the collection with the name specified in the 2nd parameter, the vectors [{id: 'id', vector: '<vectorDb>', medatada: '<metadata>'}]")
    public Stream<MapResult> upsert(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vectors") List<Map<String, Object>> vectors, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s/points";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "PUT");
        List<Map> point = vectors.stream().map(i -> {
            HashMap map = new HashMap(i);
            map.putIfAbsent("vector", map.remove("vector"));
            map.putIfAbsent("payload", map.remove("metadata"));
            return map;
        }).toList();
        Map<String, List<Map>> additionalBodies = Map.of("points", point);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.qdrant.delete")
    @Description(value="apoc.vectordb.qdrant.delete(hostOrKey, collection, ids, $configuration) - Deletes the vectors with the specified `ids`")
    public Stream<MapResult> delete(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vectors") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s/points/delete";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "POST");
        Map<String, List<Object>> additionalBodies = Map.of("points", ids);
        RestAPIConfig apiConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(apiConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.qdrant.get")
    @Description(value="apoc.vectordb.qdrant.get(hostOrKey, collection, ids, $configuration) - Gets the vectors with the specified `ids`")
    public Stream<VectorDbUtil.EmbeddingResult> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.getCommon(hostOrKey, collection, ids, configuration);
    }

    @Procedure(value="apoc.vectordb.qdrant.getAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.qdrant.getAndUpdate(hostOrKey, collection, ids, $configuration) - Gets the vectors with the specified `ids`, and optionally creates/updates neo4j entities")
    public Stream<VectorDbUtil.EmbeddingResult> getAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.getCommon(hostOrKey, collection, ids, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> getCommon(String hostOrKey, String collection, List<Object> ids, Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s/points";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromGet(config, this.procedureCallContext, ids, collection);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx);
    }

    @Procedure(value="apoc.vectordb.qdrant.query")
    @Description(value="apoc.vectordb.qdrant.query(hostOrKey, collection, vector, filter, limit, $configuration) - Retrieves closest vectors from the defined `vector`, `limit` of results, in the collection with the name specified in the 2nd parameter")
    public Stream<VectorDbUtil.EmbeddingResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="{}") Map<String, Object> filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.queryCommon(hostOrKey, collection, vector, filter, limit, configuration);
    }

    @Procedure(value="apoc.vectordb.qdrant.queryAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.chroma.queryAndUpdate(hostOrKey, collection, vector, filter, limit, $configuration) - Retrieves closest vectors from the defined `vector`, `limit` of results, in the collection with the name specified in the 2nd parameter, and optionally creates/updates neo4j entities")
    public Stream<VectorDbUtil.EmbeddingResult> queryAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="{}") Map<String, Object> filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.queryCommon(hostOrKey, collection, vector, filter, limit, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> queryCommon(String hostOrKey, String collection, List<Double> vector, Map<String, Object> filter, long limit, Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/%s/points/search";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromQuery(config, this.procedureCallContext, vector, filter, limit, collection);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx);
    }

    private Map<String, Object> getVectorDbInfo(String hostOrKey, String collection, Map<String, Object> configuration, String templateUrl) {
        return VectorDbUtil.getCommonVectorDbInfo(hostOrKey, collection, configuration, templateUrl, DB_HANDLER);
    }
}

