/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.util.MapUtil;
import apoc.util.UrlResolver;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import apoc.vectordb.VectorEmbeddingHandler;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public class WeaviateHandler
implements VectorDbHandler {
    @Override
    public String getUrl(String hostOrKey) {
        String url = new UrlResolver("http", "localhost", 8000).getUrl("weaviate", hostOrKey);
        return url + "/v1";
    }

    @Override
    public VectorEmbeddingHandler getEmbedding() {
        return new WeaviateEmbeddingHandler();
    }

    @Override
    public String getLabel() {
        return "Weaviate";
    }

    static class WeaviateEmbeddingHandler
    implements VectorEmbeddingHandler {
        WeaviateEmbeddingHandler() {
        }

        @Override
        public <T> VectorEmbeddingConfig fromGet(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<T> ids, String collection) {
            config.putIfAbsent("body", null);
            return this.populateApiBodyRequest(WeaviateEmbeddingHandler.getVectorEmbeddingConfig(config), Map.of());
        }

        @Override
        public VectorEmbeddingConfig fromQuery(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<Double> vector, Object filter, long limit, String collection) {
            List fields = procedureCallContext.outputFields().toList();
            config.putIfAbsent("method", "POST");
            VectorEmbeddingConfig vectorEmbeddingConfig = WeaviateEmbeddingHandler.getVectorEmbeddingConfig(config);
            List list = VectorDbUtil.addMetadataKeyToFields(config);
            String fieldList = String.join((CharSequence)"\n", list);
            filter = filter == null ? "" : ", where: " + String.valueOf(filter);
            String includeVector = fields.contains("vector") && vectorEmbeddingConfig.isAllResults() ? ",vector" : "";
            String additional = "_additional {id, distance " + includeVector + "}";
            String query = "{\n    Get {\n      %s(limit: %s, nearVector: {vector: %s } %s) {%s  %s}\n    }\n}\n".formatted(collection, limit, vector, filter, fieldList, additional);
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"query", query});
            return this.populateApiBodyRequest(vectorEmbeddingConfig, additionalBodies);
        }

        private static VectorEmbeddingConfig getVectorEmbeddingConfig(Map<String, Object> config) {
            config.putIfAbsent("vectorKey", "vector");
            config.putIfAbsent("metadataKey", "properties");
            return new VectorEmbeddingConfig(config);
        }
    }
}

