/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Field;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.procedure.impl.ProcedureHolder;
import org.neo4j.procedure.impl.ProcedureRegistry;

public class ProcedureHolderUtils {
    public static void unregisterProcedure(QualifiedName name, GlobalProcedures registry) {
        String kind = "procedures";
        ProcedureHolderUtils.unregisterCommon(name, registry, kind);
    }

    public static void unregisterFunction(QualifiedName name, GlobalProcedures registry) {
        String kind = "functions";
        ProcedureHolderUtils.unregisterCommon(name, registry, kind);
    }

    private static void unregisterCommon(QualifiedName name, GlobalProcedures registry, String kind) {
        try {
            GlobalProceduresRegistry globalProcRegistry = ProcedureHolderUtils.getGlobalProcRegistry(registry);
            Field registryField = GlobalProceduresRegistry.class.getDeclaredField("registry");
            registryField.setAccessible(true);
            ProcedureRegistry procedureRegistry = (ProcedureRegistry)registryField.get(globalProcRegistry);
            Field procHolderField = ProcedureRegistry.class.getDeclaredField(kind);
            procHolderField.setAccessible(true);
            ProcedureHolder procedureHolder = (ProcedureHolder)procHolderField.get(procedureRegistry);
            procedureHolder.unregister(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static GlobalProceduresRegistry getGlobalProcRegistry(GlobalProcedures registry) {
        try {
            Field globalProceduresField = Class.forName("org.neo4j.procedure.LazyProcedures").getDeclaredField("globalProcedures");
            globalProceduresField.setAccessible(true);
            return (GlobalProceduresRegistry)globalProceduresField.get(registry);
        }
        catch (Exception e) {
            return (GlobalProceduresRegistry)registry;
        }
    }
}

