/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import apoc.Extended;
import apoc.util.collection.Iterables;
import apoc.util.collection.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

@Extended
public class AggregationExtended {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;

    @UserAggregationFunction(value="apoc.agg.row")
    @Description(value="apoc.agg.row(element, predicate) - Returns index of the `element` that match the given `predicate`")
    public RowFunction row() {
        BiPredicate<Object, Object> curr = (current, value) -> (Boolean)this.db.executeTransactionally("RETURN " + value, Map.of("curr", current), result -> (Boolean)Iterators.singleOrNull((Iterator)result.columnAs((String)Iterables.single((Iterable)result.columns()))));
        return new RowFunction(curr);
    }

    @UserAggregationFunction(value="apoc.agg.position")
    @Description(value="apoc.agg.position(element, value) - Returns index of the `element` that match the given `value`")
    public RowFunction position() {
        return new RowFunction(Object::equals);
    }

    public static class RowFunction {
        private boolean found;
        private final BiPredicate<Object, Object> biPredicate;
        private long index = -1L;

        public RowFunction(BiPredicate<Object, Object> biPredicate) {
            this.biPredicate = biPredicate;
        }

        @UserAggregationUpdate
        public void update(@Name(value="value") Object value, @Name(value="element") Object element) {
            if (!this.found) {
                try {
                    this.found = this.biPredicate.test(value, element);
                }
                catch (Exception e) {
                    throw new RuntimeException("The predicate query has thrown the following exception: \n" + e.getMessage());
                }
                ++this.index;
            }
        }

        @UserAggregationResult
        public Object result() {
            return this.index;
        }
    }
}

