/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.Extended;
import apoc.custom.CustomProcedureInfo;
import apoc.custom.CypherProceduresHandler;
import apoc.custom.CypherProceduresUtil;
import apoc.custom.SignatureParser;
import apoc.custom.Signatures;
import apoc.util.ExtendedUtil;
import apoc.util.SystemDbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class CypherProcedures {
    private static final String MSG_DEPRECATION = "Please note that the current procedure is deprecated,\nit's recommended to use the `apoc.custom.installProcedure`, `apoc.custom.installFunction`, `apoc.uuid.dropProcedure` , `apoc.uuid.dropFunction` , `apoc.uuid.dropAll` procedures executed against the 'system' database\ninstead of, respectively, `apoc.uuid.declareProcedure`, `apoc.uuid.declareFunction`, `apoc.custom.removeProcedure`, `apoc.custom.removeFunction`, `apoc.custom.removeAll`.";
    public static final String ERROR_MISMATCHED_INPUTS = "Required query parameters do not match provided input arguments.";
    public static final String ERROR_MISMATCHED_OUTPUTS = "Query results do not match requested output.";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public CypherProceduresHandler cypherProceduresHandler;

    @Deprecated
    @Procedure(value="apoc.custom.declareProcedure", mode=Mode.WRITE, deprecatedBy="apoc.custom.installProcedure")
    @Description(value="apoc.custom.declareProcedure(signature, statement, mode, description) - register a custom cypher procedure")
    public void declareProcedure(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="description", defaultValue="") String description) {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        Mode modeProcedure = CypherProceduresUtil.mode(mode);
        ProcedureSignature procedureSignature = new Signatures("custom").asProcedureSignature(signature, description, modeProcedure);
        this.validateProcedure(statement, procedureSignature.inputSignature(), procedureSignature.outputSignature(), modeProcedure);
        this.cypherProceduresHandler.storeProcedure(procedureSignature, statement);
    }

    @Deprecated
    @Procedure(value="apoc.custom.declareFunction", mode=Mode.WRITE, deprecatedBy="apoc.custom.installFunction")
    @Description(value="apoc.custom.declareFunction(signature, statement, forceSingle, description) - register a custom cypher function")
    public void declareFunction(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        UserFunctionSignature userFunctionSignature = new Signatures("custom").asFunctionSignature(signature, description);
        Signatures signatures = new Signatures("custom");
        SignatureParser.FunctionContext functionContext = signatures.parseFunction(signature);
        this.validateFunction(statement, userFunctionSignature.inputSignature());
        boolean mapResult = signatures.isMapResult(functionContext);
        this.cypherProceduresHandler.storeFunction(userFunctionSignature, statement, forceSingle, mapResult);
    }

    @Procedure(value="apoc.custom.list", mode=Mode.READ)
    @Description(value="apoc.custom.list() - provide a list of custom procedures/function registered")
    public Stream<CustomProcedureInfo> list() {
        return this.cypherProceduresHandler.readSignatures().map(descriptor -> {
            String statement = descriptor.getStatement();
            if (descriptor instanceof CypherProceduresHandler.ProcedureDescriptor) {
                CypherProceduresHandler.ProcedureDescriptor procedureDescriptor = (CypherProceduresHandler.ProcedureDescriptor)descriptor;
                ProcedureSignature signature = procedureDescriptor.getSignature();
                return CustomProcedureInfo.getCustomProcedureInfo(signature, statement);
            }
            CypherProceduresHandler.UserFunctionDescriptor userFunctionDescriptor = (CypherProceduresHandler.UserFunctionDescriptor)descriptor;
            UserFunctionSignature signature = userFunctionDescriptor.getSignature();
            return CustomProcedureInfo.getCustomFunctionInfo(signature, userFunctionDescriptor.isForceSingle(), statement);
        });
    }

    @Deprecated
    @Procedure(value="apoc.custom.removeProcedure", mode=Mode.WRITE, deprecatedBy="apoc.custom.dropProcedure")
    @Description(value="apoc.custom.removeProcedure(name) - remove the targeted custom procedure")
    public void removeProcedure(@Name(value="name") String name) {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        this.cypherProceduresHandler.removeProcedure(name);
    }

    @Deprecated
    @Procedure(value="apoc.custom.removeFunction", mode=Mode.WRITE, deprecatedBy="apoc.custom.dropFunction")
    @Description(value="apoc.custom.removeFunction(name, type) - remove the targeted custom function")
    public void removeFunction(@Name(value="name") String name) {
        SystemDbUtil.checkWriteAllowed(MSG_DEPRECATION);
        this.cypherProceduresHandler.removeFunction(name);
    }

    private void validateFunction(String statement, List<FieldSignature> input) {
        this.validateProcedure(statement, input, CypherProceduresHandler.DEFAULT_MAP_OUTPUT, null);
    }

    private void validateProcedure(String statement, List<FieldSignature> input, List<FieldSignature> output, Mode mode) {
        Set outputSet = output.stream().map(FieldSignature::name).collect(Collectors.toSet());
        this.api.executeTransactionally("EXPLAIN " + statement, (Map)input.stream().collect(HashMap::new, (map, value) -> map.put(value.name(), null), HashMap::putAll), result -> {
            if (!CypherProceduresHandler.DEFAULT_MAP_OUTPUT.equals(output)) {
                Set<String> columns = result.columns().stream().map(i -> i.replaceFirst("@[0-9]+", "").trim()).collect(Collectors.toSet());
                this.checkOutputParams(outputSet, columns);
            }
            if (!CypherProceduresHandler.DEFAULT_INPUTS.equals(input)) {
                this.checkInputParams((Result)result);
            }
            if (mode != null) {
                this.checkMode((Result)result, mode);
            }
            return null;
        });
    }

    private void checkMode(Result result, final Mode mode) {
        HashSet<Mode> modes = new HashSet<Mode>(){
            {
                this.add(mode);
                this.add(Mode.DEFAULT);
                this.add(Mode.READ);
            }
        };
        if (mode.equals((Object)Mode.SCHEMA)) {
            modes.add(Mode.WRITE);
        }
        if (!ExtendedUtil.procsAreValid((GraphDatabaseService)this.api, (Set<Mode>)modes, result)) {
            throw new RuntimeException("One or more inner procedure modes have operation different from the mode parameter: " + mode);
        }
        this.checkCorrectQueryType(result, mode);
    }

    private void checkCorrectQueryType(Result result, Mode mode) {
        List<QueryExecutionType.QueryType> dbmsQueryTypes;
        List<QueryExecutionType.QueryType> schemaQueryTypes;
        List<QueryExecutionType.QueryType> writeQueryTypes;
        List<QueryExecutionType.QueryType> readQueryTypes = List.of(QueryExecutionType.QueryType.READ_ONLY);
        Map<Mode, List<QueryExecutionType.QueryType>> modeQueryTypeMap = Map.of(Mode.READ, readQueryTypes, Mode.WRITE, writeQueryTypes = List.of(QueryExecutionType.QueryType.READ_ONLY, QueryExecutionType.QueryType.WRITE, QueryExecutionType.QueryType.READ_WRITE), Mode.SCHEMA, schemaQueryTypes = List.of(QueryExecutionType.QueryType.READ_ONLY, QueryExecutionType.QueryType.WRITE, QueryExecutionType.QueryType.READ_WRITE, QueryExecutionType.QueryType.SCHEMA_WRITE), Mode.DBMS, dbmsQueryTypes = List.of(QueryExecutionType.QueryType.READ_ONLY, QueryExecutionType.QueryType.DBMS));
        List<QueryExecutionType.QueryType> queryTypes = modeQueryTypeMap.get(mode);
        QueryExecutionType.QueryType queryType = ExtendedUtil.isQueryValid(result, (QueryExecutionType.QueryType[])queryTypes.toArray(QueryExecutionType.QueryType[]::new));
        if (queryType != null) {
            String correspondenceList = modeQueryTypeMap.entrySet().stream().map(i -> "- Mode: " + i.getKey() + " can have as a query execution type: " + i.getValue()).collect(Collectors.joining("\n"));
            throw new RuntimeException(String.format("The query execution type of the statement is: `%s`, but you provided as a parameter mode: `%s`.\nYou have to declare a `mode` which corresponds to one of the following query execution type.\nThat is:\n%s", queryType.name(), mode.name(), correspondenceList));
        }
    }

    private void checkOutputParams(Set<String> outputSet, Set<String> columns) {
        if (!Set.copyOf(columns).equals(outputSet)) {
            throw new RuntimeException(ERROR_MISMATCHED_OUTPUTS);
        }
    }

    private void checkInputParams(Result result) {
        String missingParameters = StreamSupport.stream(result.getNotifications().spliterator(), false).filter(i -> i.getCode().equals(Status.Statement.ParameterMissing.code().serialize())).map(Notification::getDescription).collect(Collectors.joining(System.lineSeparator()));
        if (StringUtils.isNotBlank((CharSequence)missingParameters)) {
            throw new RuntimeException(ERROR_MISMATCHED_INPUTS);
        }
    }
}

