/*
 * Decompiled with CFR 0.152.
 */
package apoc.dv;

import apoc.ExtendedSystemLabels;
import apoc.ExtendedSystemPropertyKeys;
import apoc.SystemPropertyKeys;
import apoc.dv.VirtualizedResource;
import apoc.util.JsonUtil;
import apoc.util.Util;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class DataVirtualizationCatalogHandler {
    private final GraphDatabaseService db;
    private final GraphDatabaseService systemDb;
    private final Log log;

    public DataVirtualizationCatalogHandler(GraphDatabaseService db, GraphDatabaseService systemDb, Log log) {
        this.db = db;
        this.systemDb = systemDb;
        this.log = log;
    }

    private <T> T withSystemDb(Function<Transaction, T> action) {
        try (Transaction tx = this.systemDb.beginTx();){
            T result = action.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public VirtualizedResource add(VirtualizedResource vr) {
        return this.withSystemDb(tx -> {
            Node node = Util.mergeNode((Transaction)tx, (Label)ExtendedSystemLabels.DataVirtualizationCatalog, null, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.db.databaseName()), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)vr.name)});
            node.setProperty(ExtendedSystemPropertyKeys.data.name(), (Object)JsonUtil.writeValueAsString((Object)vr));
            return vr;
        });
    }

    public VirtualizedResource get(String name) {
        return this.withSystemDb(tx -> {
            List nodes = tx.findNodes((Label)ExtendedSystemLabels.DataVirtualizationCatalog, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.name.name(), (Object)name).stream().collect(Collectors.toList());
            if (nodes.size() > 1) {
                throw new RuntimeException("More than 1 result");
            }
            try {
                Node node = (Node)nodes.get(0);
                Map map = (Map)JsonUtil.OBJECT_MAPPER.readValue(node.getProperty(ExtendedSystemPropertyKeys.data.name()).toString(), Map.class);
                return VirtualizedResource.from(name, map);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Stream<VirtualizedResource> remove(String name) {
        this.withSystemDb(tx -> {
            tx.findNodes((Label)ExtendedSystemLabels.DataVirtualizationCatalog, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.name.name(), (Object)name).stream().forEach(Node::delete);
            return null;
        });
        return this.list();
    }

    public Stream<VirtualizedResource> list() {
        return this.withSystemDb(tx -> tx.findNodes((Label)ExtendedSystemLabels.DataVirtualizationCatalog, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).stream().map(node -> {
            try {
                Map map = (Map)JsonUtil.OBJECT_MAPPER.readValue(node.getProperty(ExtendedSystemPropertyKeys.data.name()).toString(), Map.class);
                String name = node.getProperty(SystemPropertyKeys.name.name()).toString();
                return VirtualizedResource.from(name, map);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()).stream());
    }
}

