/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import apoc.ApocConfig;
import apoc.Description;
import apoc.Extended;
import apoc.Pools;
import apoc.export.parquet.ExportParquetGraphFileStrategy;
import apoc.export.parquet.ExportParquetGraphStreamStrategy;
import apoc.export.parquet.ExportParquetResultFileStrategy;
import apoc.export.parquet.ExportParquetResultStreamStrategy;
import apoc.export.parquet.ParquetConfig;
import apoc.export.parquet.ParquetExportType;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.result.ByteArrayResult;
import apoc.result.ExportProgressInfo;
import apoc.util.FileUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class ExportParquet {
    public static final String EXPORT_TO_FILE_PARQUET_ERROR = "Export to files not enabled, please set apoc.export.file.enabled=true in your apoc.conf.\nOtherwise, if you are running in a cloud environment without filesystem access, use the apoc.export.parquet.*.stream procedures to stream the export back to your client.";
    @Context
    public Transaction tx;
    @Context
    public Log log;
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.export.parquet.all.stream")
    @Description(value="Exports the full database as a Parquet byte array.")
    public Stream<ByteArrayResult> all(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.exportParquet(new DatabaseSubGraph(this.tx), new ParquetConfig(config));
    }

    @Procedure(value="apoc.export.parquet.data.stream")
    @Description(value="Exports the given nodes and relationships as a Parquet byte array.")
    public Stream<ByteArrayResult> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ParquetConfig conf = new ParquetConfig(config);
        return this.exportParquet(new NodesAndRelsSubGraph(this.tx, nodes, rels), conf);
    }

    @Procedure(value="apoc.export.parquet.graph.stream")
    @Description(value="Exports the given graph as a Parquet byte array.")
    public Stream<ByteArrayResult> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        ParquetConfig conf = new ParquetConfig(config);
        return this.exportParquet(new NodesAndRelsSubGraph(this.tx, nodes, rels), conf);
    }

    @Procedure(value="apoc.export.parquet.query.stream")
    @Description(value="Exports the given Cypher query as a Parquet byte array.")
    public Stream<ByteArrayResult> query(@Name(value="query") String query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ParquetConfig exportConfig = new ParquetConfig(config);
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        return this.exportParquet(result, exportConfig);
    }

    @Procedure(value="apoc.export.parquet.all")
    @Description(value="Exports the full database as a Parquet file.")
    public Stream<ExportProgressInfo> all(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        return this.exportParquet(fileName, new DatabaseSubGraph(this.tx), new ParquetConfig(config));
    }

    @Procedure(value="apoc.export.parquet.data")
    @Description(value="Exports the given nodes and relationships as a Parquet file.")
    public Stream<ExportProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        ParquetConfig conf = new ParquetConfig(config);
        return this.exportParquet(fileName, new NodesAndRelsSubGraph(this.tx, nodes, rels), conf);
    }

    @Procedure(value="apoc.export.parquet.graph")
    @Description(value="Exports the given graph as a Parquet file.")
    public Stream<ExportProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        ParquetConfig conf = new ParquetConfig(config);
        return this.exportParquet(fileName, new NodesAndRelsSubGraph(this.tx, nodes, rels), conf);
    }

    @Procedure(value="apoc.export.parquet.query")
    @Description(value="Exports the given Cypher query as a Parquet file.")
    public Stream<ExportProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws Exception {
        ParquetConfig exportConfig = new ParquetConfig(config);
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        return this.exportParquet(fileName, result, exportConfig);
    }

    public Stream<ExportProgressInfo> exportParquet(String fileName, Object data, ParquetConfig config) throws IOException, URLAccessValidationError {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new RuntimeException("The fileName must exists. Otherwise, use the `apoc.export.parquet.*.stream.` procedures to stream the export back to your client.");
        }
        fileName = FileUtils.changeFileUrlIfImportDirectoryConstrained((String)fileName, (URLAccessChecker)this.urlAccessChecker);
        if (!ApocConfig.apocConfig().getBoolean("apoc.export.file.enabled")) {
            throw new RuntimeException(EXPORT_TO_FILE_PARQUET_ERROR);
        }
        ParquetExportType exportType = ParquetExportType.Type.from(data);
        if (data instanceof Result) {
            return new ExportParquetResultFileStrategy(fileName, this.db, this.pools, this.terminationGuard, this.log, exportType).export((Result)data, config);
        }
        return new ExportParquetGraphFileStrategy(fileName, this.db, this.pools, this.terminationGuard, this.log, exportType).export((SubGraph)data, config);
    }

    public Stream<ByteArrayResult> exportParquet(Object data, ParquetConfig config) {
        ParquetExportType exportType = ParquetExportType.Type.from(data);
        if (data instanceof Result) {
            return new ExportParquetResultStreamStrategy(this.db, this.pools, this.terminationGuard, this.log, exportType).export((Result)data, config);
        }
        return new ExportParquetGraphStreamStrategy(this.db, this.pools, this.terminationGuard, this.log, exportType).export((SubGraph)data, config);
    }
}

