/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.parquet;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public record ParquetBufferedWriter(OutputStream out) implements OutputFile
{
    public PositionOutputStream create(long blockSizeHint) {
        return this.createPositionOutputstream();
    }

    public PositionOutputStream createOrOverwrite(long blockSizeHint) {
        return this.createPositionOutputstream();
    }

    private PositionOutputStream createPositionOutputstream() {
        return new PositionOutputStream(){
            int pos = 0;

            public long getPos() {
                return this.pos;
            }

            public void flush() throws IOException {
                ParquetBufferedWriter.this.out.flush();
            }

            public void close() throws IOException {
                ParquetBufferedWriter.this.out.close();
            }

            public void write(int b) throws IOException {
                ParquetBufferedWriter.this.out.write(b);
                ++this.pos;
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ParquetBufferedWriter.this.out.write(b, off, len);
                this.pos += len;
            }
        };
    }

    public boolean supportsBlockSize() {
        return false;
    }

    public long defaultBlockSize() {
        return 0L;
    }
}

