/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.xls;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.xls.ExportXlsHandler;
import apoc.result.ExportProgressInfo;
import apoc.util.MissingDependencyException;
import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class ExportXls {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public ApocConfig apocConfig;

    @Procedure
    @Description(value="apoc.export.xls.all(file,config) - exports whole database as xls to the provided file")
    public Stream<ExportProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount((Transaction)this.tx), Util.relCount((Transaction)this.tx));
        return this.exportXls(fileName, source, new DatabaseSubGraph(this.tx), config);
    }

    @Procedure
    @Description(value="apoc.export.xls.data(nodes,rels,file,config) - exports given nodes and relationships as xls to the provided file")
    public Stream<ExportProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportXls(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.xls.graph(graph,file,config) - exports given graph object as xls to the provided file")
    public Stream<ExportProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportXls(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.xls.query(query,file,{config,...,params:{params}}) - exports results from the cypher statement as xls to the provided file")
    public Stream<ExportProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        String source = String.format("statement: cols(%d)", result.columns().size());
        return this.exportXls(fileName, source, result, config);
    }

    private Stream<ExportProgressInfo> exportXls(@Name(value="file") String fileName, String source, Object data, Map<String, Object> configMap) throws Exception {
        try {
            return ExportXlsHandler.getProgressInfoStream(fileName, source, data, configMap, this.apocConfig, this.db);
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException("Cannot find the needed jar into the plugins folder in order to use . \nPlease see the documentation: https://neo4j.com/labs/apoc/5/overview/apoc.export/apoc.export.xls.all/#_install_dependencies");
        }
    }
}

