/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.util;

import apoc.load.util.LoadJdbcConfig;
import apoc.util.Util;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;

public class JdbcUtil {
    private static final String KEY_NOT_FOUND_MESSAGE = "No apoc.jdbc.%s.url url specified";
    private static final String LOAD_TYPE = "jdbc";

    private JdbcUtil() {
    }

    public static Object getConnection(String jdbcUrl, LoadJdbcConfig config, Class<?> classType) throws Exception {
        if (config.hasCredentials()) {
            return JdbcUtil.createConnection(jdbcUrl, config.getCredentials().getUser(), config.getCredentials().getPassword(), classType);
        }
        URI uri = new URI(jdbcUrl.substring("jdbc:".length()));
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String cleanUrl = jdbcUrl.substring(0, jdbcUrl.indexOf("://") + 3) + jdbcUrl.substring(jdbcUrl.indexOf("@") + 1);
            String[] user = userInfo.split(":");
            return JdbcUtil.createConnection(cleanUrl, user[0], user[1], classType);
        }
        return DriverManager.getConnection(jdbcUrl);
    }

    private static Object createConnection(String jdbcUrl, String userName, String password, Class<?> classType) throws Exception {
        if (jdbcUrl.contains(";auth=kerberos")) {
            String client = System.getProperty("java.security.auth.login.config.client", "KerberosClient");
            LoginContext lc = new LoginContext(client, callbacks -> {
                for (Callback cb : callbacks) {
                    if (cb instanceof NameCallback) {
                        ((NameCallback)cb).setName(userName);
                    }
                    if (!(cb instanceof PasswordCallback)) continue;
                    ((PasswordCallback)cb).setPassword(password.toCharArray());
                }
            });
            lc.login();
            Subject subject = lc.getSubject();
            try {
                return Subject.doAs(subject, () -> JdbcUtil.createConnectionByClass(jdbcUrl, userName, password, classType));
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return JdbcUtil.createConnectionByClass(jdbcUrl, userName, password, classType);
    }

    private static Object createConnectionByClass(String jdbcUrl, String userName, String password, Class<?> classType) throws SQLException {
        if (classType.isAssignableFrom(DatabaseConnectionSource.class)) {
            return DatabaseConnectionSources.newDatabaseConnectionSource((String)jdbcUrl, (UserCredentials)new MultiUseUserCredentials(userName, password));
        }
        return DriverManager.getConnection(jdbcUrl, userName, password);
    }

    public static String getUrlOrKey(String urlOrKey) {
        return urlOrKey.contains(":") ? urlOrKey : (String)Util.getLoadUrlByConfigFile((String)LOAD_TYPE, (String)urlOrKey, (String)"url").orElseThrow(() -> new RuntimeException(String.format(KEY_NOT_FOUND_MESSAGE, urlOrKey)));
    }

    public static String getSqlOrKey(String sqlOrKey) {
        return sqlOrKey.contains(" ") ? sqlOrKey : (String)((Object)Util.getLoadUrlByConfigFile((String)LOAD_TYPE, (String)sqlOrKey, (String)"sql").orElse("SELECT * FROM " + sqlOrKey));
    }

    public static String obfuscateJdbcUrl(String query) {
        return query.replaceAll("(jdbc:[^:]+://)([^\\s\\\"']+)", "$1*******");
    }
}

