/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.util;

import apoc.export.util.BatchTransaction;
import apoc.export.util.CountingInputStream;
import apoc.export.util.ExportConfig;
import apoc.export.util.Reporter;
import apoc.result.MapResult;
import apoc.util.CompressionAlgo;
import apoc.util.ExtendedUtil;
import apoc.util.FileUtils;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.TerminationGuard;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlReadUtil {

    static interface NodeExport {
        public ExportConfig.NodeConfig getNodeConfigReader(Import var1);

        public static enum NodeType {
            SOURCE("source", Import::getSource),
            TARGET("target", Import::getTarget);

            private final String name;
            private final NodeExport exportNode;

            private NodeType(String name, NodeExport exportNode) {
                this.name = name;
                this.exportNode = exportNode;
            }

            public String getName() {
                return this.name;
            }

            public String getNameType() {
                return this.name + "Type";
            }

            NodeExport get() {
                return this.exportNode;
            }
        }
    }

    public static class Import {
        public static final String LABEL_SPLIT = " *: *";
        private final GraphDatabaseService db;
        private boolean storeNodeIds;
        private RelationshipType defaultRelType = RelationshipType.withName((String)"UNKNOWN");
        private ExportConfig.NodeConfig source;
        private ExportConfig.NodeConfig target;
        private int batchSize = 40000;
        private Reporter reporter;
        private boolean labels;
        public static final QName ID = QName.valueOf("id");
        public static final QName LABELS = QName.valueOf("labels");
        public static final QName LABEL = QName.valueOf("label");
        public static final QName VALUE = QName.valueOf("value");
        public static final QName FOR = QName.valueOf("for");
        public static final QName NAME = QName.valueOf("attr.name");
        public static final QName TYPE = QName.valueOf("attr.type");
        public static final QName DATA_TYPE = QName.valueOf("type");
        public static final QName LIST = QName.valueOf("attr.list");
        public static final QName KEY = QName.valueOf("key");
        public static final QName KIND = QName.valueOf("kind");

        public Import storeNodeIds() {
            this.storeNodeIds = true;
            return this;
        }

        public Import relType(String name) {
            this.defaultRelType = RelationshipType.withName((String)name);
            return this;
        }

        public Import batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Import nodeLabels(boolean readLabels) {
            this.labels = readLabels;
            return this;
        }

        public Import source(ExportConfig.NodeConfig sourceConfig) {
            this.source = sourceConfig;
            return this;
        }

        public Import target(ExportConfig.NodeConfig targetConfig) {
            this.target = targetConfig;
            return this;
        }

        public Import reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public ExportConfig.NodeConfig getSource() {
            return this.source;
        }

        public ExportConfig.NodeConfig getTarget() {
            return this.target;
        }

        public Import(GraphDatabaseService db) {
            this.db = db;
        }

        public long parseXML(Reader input, TerminationGuard terminationGuard) throws XMLStreamException {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            HashMap<String, String> cache = new HashMap<String, String>(32768);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XMLEventReader reader = inputFactory.createXMLEventReader(input);
            Node last = null;
            HashMap<String, Key> nodeKeys = new HashMap<String, Key>();
            HashMap<String, Key> relKeys = new HashMap<String, Key>();
            int count = 0;
            BatchTransaction tx = new BatchTransaction(this.db, this.batchSize * 10, this.reporter);
            try {
                while (reader.hasNext()) {
                    String id;
                    StartElement element;
                    String name;
                    XMLEvent event;
                    terminationGuard.check();
                    try {
                        event = (XMLEvent)reader.next();
                        if (event.getEventType() == 11) {
                            Load.generateXmlDoctypeException();
                        }
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("Unexpected EOF")) break;
                        if (!e.getMessage().contains("DOCTYPE")) continue;
                        throw e;
                    }
                    if (!event.isStartElement() || (name = (element = event.asStartElement()).getName().getLocalPart()).equals("graphml") || name.equals("graph") || name.equals("gexf")) continue;
                    if (name.equals("attribute")) {
                        id = this.getAttribute(element, ID);
                        String type = this.getAttribute(element, DATA_TYPE);
                        dataMap.put(id, type);
                    }
                    if (name.equals("key")) {
                        id = this.getAttribute(element, ID);
                        Key key = new Key(this.getAttribute(element, NAME), this.getAttribute(element, TYPE), this.getAttribute(element, LIST), this.getAttribute(element, FOR));
                        XMLEvent next = this.peek(reader);
                        if (next.isStartElement() && next.asStartElement().getName().getLocalPart().equals("default")) {
                            reader.nextEvent().asStartElement();
                            key.setDefault(reader.nextEvent().asCharacters().getData());
                        }
                        if (key.forNode) {
                            nodeKeys.put(id, key);
                            continue;
                        }
                        relKeys.put(id, key);
                        continue;
                    }
                    if (name.equals("attvalue")) {
                        Key key;
                        if (last == null) continue;
                        id = this.getAttribute(element, FOR);
                        boolean isNode = last instanceof Node;
                        Key key2 = key = isNode ? (Key)nodeKeys.get(id) : (Key)relKeys.get(id);
                        if (key == null) {
                            key = Key.defaultKey(id, isNode);
                        }
                        Map.Entry<XMLEvent, Object> eventEntry = this.getDataEventEntry(reader, key);
                        XMLEvent next = eventEntry.getKey();
                        String value = this.getAttribute(element, VALUE);
                        if (value != null) {
                            if (this.labels && isNode && id.equals("labels")) {
                                this.addLabels(last, value.toString());
                                continue;
                            }
                            if (this.labels && !isNode && id.equals("label")) continue;
                            Object convertedValue = ExtendedUtil.toValidValue(value, key.nameOrId, dataMap);
                            last.setProperty(key.nameOrId, convertedValue);
                            if (this.reporter == null) continue;
                            this.reporter.update(0L, 0L, 1L);
                            continue;
                        }
                        if (next.getEventType() != 2) continue;
                        last.setProperty(key.nameOrId, (Object)"");
                        this.reporter.update(0L, 0L, 1L);
                        continue;
                    }
                    if (name.equals("node")) {
                        tx.increment();
                        id = this.getAttribute(element, ID);
                        Node node = tx.getTransaction().createNode();
                        if (this.labels) {
                            String labels = this.getAttribute(element, LABEL);
                            this.addLabels(node, labels);
                        }
                        if (this.storeNodeIds) {
                            node.setProperty("id", (Object)id);
                        }
                        this.setDefaults(nodeKeys, (Entity)node);
                        last = node;
                        cache.put(id, node.getElementId());
                        if (this.reporter != null) {
                            this.reporter.update(1L, 0L, 0L);
                        }
                        ++count;
                        continue;
                    }
                    if (!name.equals("edge")) continue;
                    tx.increment();
                    String label = this.getAttribute(element, KIND);
                    Node from = this.getByNodeId(cache, tx.getTransaction(), element, NodeExport.NodeType.SOURCE);
                    Node to = this.getByNodeId(cache, tx.getTransaction(), element, NodeExport.NodeType.TARGET);
                    RelationshipType relationshipType = label == null ? this.getRelationshipType(reader) : RelationshipType.withName((String)label);
                    Relationship relationship = from.createRelationshipTo(to, relationshipType);
                    this.setDefaults(relKeys, (Entity)relationship);
                    last = relationship;
                    if (this.reporter != null) {
                        this.reporter.update(0L, 1L, 0L);
                    }
                    ++count;
                }
                tx.doCommit();
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
            finally {
                tx.close();
                reader.close();
            }
            return count;
        }

        private Map.Entry<XMLEvent, Object> getDataEventEntry(XMLEventReader reader, Key key) {
            Object value = key.defaultValue;
            Map.Entry<XMLEvent, String> peekEntry = this.peekRecursively(reader, null);
            if (peekEntry.getValue() != null) {
                value = key.parseValue(peekEntry.getValue());
            }
            return new AbstractMap.SimpleEntry<XMLEvent, Object>(peekEntry.getKey(), value);
        }

        private Map.Entry<XMLEvent, String> peekRecursively(XMLEventReader reader, String data) {
            try {
                XMLEvent peek = this.peek(reader);
                if (peek.isCharacters()) {
                    data = StringUtils.join((Object[])new String[]{data, reader.nextEvent().asCharacters().getData()});
                    return this.peekRecursively(reader, data);
                }
                return new AbstractMap.SimpleEntry<XMLEvent, String>(peek, data);
            }
            catch (Exception e) {
                return this.peekRecursively(reader, data);
            }
        }

        private Node getByNodeId(Map<String, String> cache, Transaction tx, StartElement element, NodeExport.NodeType nodeType) {
            NodeExport xmlNodeInterface = nodeType.get();
            ExportConfig.NodeConfig nodeConfig = xmlNodeInterface.getNodeConfigReader(this);
            String sourceTargetValue = this.getAttribute(element, QName.valueOf(nodeType.getName()));
            String id = cache.get(sourceTargetValue);
            if (StringUtils.isBlank((CharSequence)nodeConfig.label)) {
                return tx.getNodeByElementId(id);
            }
            String attribute = this.getAttribute(element, QName.valueOf(nodeType.getNameType()));
            String value = attribute == null ? sourceTargetValue : Type.forType(attribute).parse(sourceTargetValue);
            return tx.findNode(Label.label((String)nodeConfig.label), Optional.ofNullable(nodeConfig.id).orElse("id"), (Object)value);
        }

        private RelationshipType getRelationshipType(XMLEventReader reader) throws XMLStreamException {
            if (this.labels) {
                boolean notStartElementOrContainsKeyLabel;
                XMLEvent peek = reader.peek();
                boolean isChar = peek.isCharacters();
                if (isChar && !peek.asCharacters().isWhiteSpace()) {
                    String el;
                    String value = peek.asCharacters().getData();
                    String typeRel = value.contains(el = ":") ? value.replace(el, "") : value;
                    return RelationshipType.withName((String)typeRel.trim());
                }
                boolean bl = notStartElementOrContainsKeyLabel = isChar || !peek.isStartElement() || this.containsLabelKey(peek);
                if (!peek.isEndDocument() && notStartElementOrContainsKeyLabel) {
                    reader.nextEvent();
                    return this.getRelationshipType(reader);
                }
            }
            reader.nextEvent();
            return this.defaultRelType;
        }

        private boolean containsLabelKey(XMLEvent peek) {
            Attribute keyAttribute = peek.asStartElement().getAttributeByName(new QName("key"));
            return keyAttribute != null && keyAttribute.getValue().equals("label");
        }

        private void addLabels(Node node, String labels) {
            String[] parts;
            if (labels == null) {
                return;
            }
            if ((labels = labels.trim()).isEmpty()) {
                return;
            }
            for (String part : parts = labels.split(LABEL_SPLIT)) {
                if (part.trim().isEmpty()) continue;
                node.addLabel(Label.label((String)part.trim()));
            }
        }

        private XMLEvent peek(XMLEventReader reader) throws XMLStreamException {
            XMLEvent peek = reader.peek();
            if (peek.isCharacters() && peek.asCharacters().isWhiteSpace()) {
                reader.nextEvent();
                return this.peek(reader);
            }
            return peek;
        }

        private void setDefaults(Map<String, Key> keys, Entity pc) {
            if (keys.isEmpty()) {
                return;
            }
            for (Key key : keys.values()) {
                if (key.defaultValue == null) continue;
                pc.setProperty(key.nameOrId, key.defaultValue);
            }
        }

        private String getAttribute(StartElement element, QName qname) {
            Attribute attribute = element.getAttributeByName(qname);
            return attribute != null ? attribute.getValue() : null;
        }

        static class Key {
            String nameOrId;
            boolean forNode;
            Type listType;
            Type type;
            Object defaultValue;

            public Key(String nameOrId, String type, String listType, String forNode) {
                this.nameOrId = nameOrId;
                this.type = Type.forType(type);
                if (listType != null) {
                    this.listType = Type.forType(listType);
                }
                this.forNode = forNode == null || forNode.equalsIgnoreCase("node");
            }

            private static Key defaultKey(String id, boolean forNode) {
                return new Key(id, "string", null, forNode ? "node" : "edge");
            }

            public void setDefault(String data) {
                this.defaultValue = this.type.parse(data);
            }

            public Object parseValue(String input) {
                if (input == null || input.trim().isEmpty()) {
                    return this.defaultValue;
                }
                if (this.listType != null) {
                    return this.listType.parseList(input);
                }
                return this.type.parse(input);
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static enum Type {
            BOOLEAN{

                @Override
                Object parse(String value) {
                    return Boolean.valueOf(value);
                }

                @Override
                Object parseList(String value) {
                    return Type.parseList(value, Boolean.class, i -> (Boolean)i);
                }
            }
            ,
            INT{

                @Override
                Object parse(String value) {
                    return Integer.parseInt(value);
                }

                @Override
                Object parseList(String value) {
                    return Type.parseList(value, Integer.class, n -> ((Number)n).intValue());
                }
            }
            ,
            LONG{

                @Override
                Object parse(String value) {
                    return Long.parseLong(value);
                }

                @Override
                Object parseList(String value) {
                    return Type.parseList(value, Long.class, i -> ((Number)i).longValue());
                }
            }
            ,
            FLOAT{

                @Override
                Object parse(String value) {
                    return Float.valueOf(Float.parseFloat(value));
                }

                @Override
                Object parseList(String value) {
                    return Type.parseList(value, Float.class, i -> Float.valueOf(((Number)i).floatValue()));
                }
            }
            ,
            DOUBLE{

                @Override
                Object parse(String value) {
                    return Double.parseDouble(value);
                }

                @Override
                Object parseList(String value) {
                    return Type.parseList(value, Double.class, i -> ((Number)i).doubleValue());
                }
            }
            ,
            STRING{

                @Override
                Object parse(String value) {
                    return value;
                }

                @Override
                Object parseList(String value) {
                    return Type.parseList(value, String.class, i -> (String)i);
                }
            };


            abstract Object parse(String var1);

            abstract Object parseList(String var1);

            public static <T> T[] parseList(String value, Class<T> asClass, Function<Object, T> convert) {
                List parsed = (List)JsonUtil.parse((String)value, null, List.class);
                Object[] converted = (Object[])Array.newInstance(asClass, parsed.size());
                for (int i = 0; i < parsed.size(); ++i) {
                    converted[i] = convert.apply(parsed.get(i));
                }
                return converted;
            }

            public static Type forType(String type) {
                if (type == null) {
                    return STRING;
                }
                return Type.valueOf(type.trim().toUpperCase());
            }
        }
    }

    public static class Load {
        public static Stream<MapResult> xmlXpathToMapResult(Object urlOrBinary, URLAccessChecker urlAccessChecker, TerminationGuard terminationGuard, Map<String, Object> config) throws Exception {
            if (config == null) {
                config = Collections.emptyMap();
            }
            boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
            String path = (String)config.getOrDefault("path", "/");
            boolean simpleMode = Util.toBoolean((Object)config.getOrDefault("simpleMode", false));
            try {
                Map headers = config.getOrDefault("headers", Collections.emptyMap());
                CountingInputStream is = FileUtils.inputStreamFor((Object)urlOrBinary, headers, null, (String)((String)config.getOrDefault("compression", CompressionAlgo.NONE.name())), (URLAccessChecker)urlAccessChecker);
                return Load.parse((InputStream)is, simpleMode, path, failOnError, terminationGuard);
            }
            catch (Exception e) {
                if (!failOnError) {
                    return Stream.of(new MapResult(Collections.emptyMap()));
                }
                throw e;
            }
        }

        private static Stream<MapResult> parse(InputStream data, boolean simpleMode, String path, boolean failOnError, TerminationGuard terminationGuard) throws Exception {
            ArrayList<MapResult> result = new ArrayList<MapResult>();
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
                Document doc = documentBuilder.parse(data);
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                path = StringUtils.isEmpty((CharSequence)path) ? "/" : path;
                XPathExpression xPathExpression = xPath.compile(path);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    LinkedList<Map<String, Object>> stack = new LinkedList<Map<String, Object>>();
                    Load.handleNode(stack, nodeList.item(i), simpleMode, terminationGuard);
                    for (int index = 0; index < stack.size(); ++index) {
                        result.add(new MapResult((Map)stack.pollFirst()));
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (!failOnError) {
                    return Stream.of(new MapResult(Collections.emptyMap()));
                }
                throw e;
            }
            catch (Exception e) {
                if (!failOnError) {
                    return Stream.of(new MapResult(Collections.emptyMap()));
                }
                if (e instanceof SAXParseException && e.getMessage().contains("DOCTYPE is disallowed")) {
                    throw Load.generateXmlDoctypeException();
                }
                throw e;
            }
            return result.stream();
        }

        private static void handleTypeAndAttributes(org.w3c.dom.Node node, Map<String, Object> elementMap) {
            if (node.getLocalName() != null) {
                elementMap.put("_type", node.getLocalName());
            }
            if (node.getAttributes() != null) {
                NamedNodeMap attributeMap = node.getAttributes();
                for (int i = 0; i < attributeMap.getLength(); ++i) {
                    org.w3c.dom.Node attribute = attributeMap.item(i);
                    elementMap.put(attribute.getNodeName(), attribute.getNodeValue());
                }
            }
        }

        private static void handleNode(Deque<Map<String, Object>> stack, org.w3c.dom.Node node, boolean simpleMode, TerminationGuard terminationGuard) {
            terminationGuard.check();
            if (node.getNodeType() == 9) {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getLocalName() == null) continue;
                    Load.handleNode(stack, children.item(i), simpleMode, terminationGuard);
                    return;
                }
            }
            LinkedHashMap<String, Object> elementMap = new LinkedHashMap<String, Object>();
            Load.handleTypeAndAttributes(node, elementMap);
            NodeList children = node.getChildNodes();
            int count = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                    Load.handleNode(stack, child, simpleMode, terminationGuard);
                    ++count;
                    continue;
                }
                Load.handleTextNode(child, elementMap);
            }
            if (children.getLength() > 0 && !stack.isEmpty()) {
                ArrayList<Map<String, Object>> nodeChildren = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < count; ++i) {
                    nodeChildren.add(stack.pollLast());
                }
                String key = simpleMode ? "_" + node.getLocalName() : "_children";
                Collections.reverse(nodeChildren);
                if (nodeChildren.size() > 0) {
                    Object text = elementMap.get("_text");
                    if (text instanceof List) {
                        for (Object element : (List)text) {
                            nodeChildren.add((Map<String, Object>)element);
                        }
                        elementMap.remove("_text");
                    }
                    elementMap.put(key, nodeChildren);
                }
            }
            if (!elementMap.isEmpty()) {
                stack.addLast(elementMap);
            }
        }

        private static void handleTextNode(org.w3c.dom.Node node, Map<String, Object> elementMap) {
            Object text = "";
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 3: {
                    text = Load.normalizeText(node.getNodeValue());
                    break;
                }
                case 4: {
                    text = Load.normalizeText(((CharacterData)node).getData());
                    break;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)text.toString())) {
                Object previousText = elementMap.get("_text");
                if (previousText != null) {
                    text = Arrays.asList(previousText.toString(), text);
                }
                elementMap.put("_text", text);
            }
        }

        private static String normalizeText(String text) {
            Object[] tokens = StringUtils.split((String)text, (String)"\n");
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = ((String)tokens[i]).trim();
            }
            return StringUtils.join((Object[])tokens, (String)" ").trim();
        }

        public static RuntimeException generateXmlDoctypeException() {
            throw new RuntimeException("XML documents with a DOCTYPE are not allowed.");
        }
    }
}

