/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.xls;

import apoc.export.util.CountingInputStream;
import apoc.load.xls.LoadXls;
import apoc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.neo4j.values.storable.LocalDateTimeValue;

public class LoadXlsHandler {
    public static XLSSpliterator getXlsSpliterator(String url, CountingInputStream stream, LoadXls.Selection selection, long skip, boolean hasHeader, long limit, List<String> ignore, List<Object> nullValues, Map<String, LoadXls.Mapping> mappings, boolean skipNulls) throws IOException {
        Workbook workbook = WorkbookFactory.create((InputStream)stream);
        Sheet sheet = workbook.getSheet(selection.sheet);
        if (sheet == null) {
            throw new IllegalStateException("Sheet " + selection.sheet + " not found");
        }
        selection.updateVertical(sheet.getFirstRowNum(), sheet.getLastRowNum());
        Row firstRow = sheet.getRow(selection.top);
        selection.updateHorizontal(firstRow.getFirstCellNum(), firstRow.getLastCellNum());
        String[] header = LoadXlsHandler.getHeader(hasHeader, skipNulls, firstRow, selection, ignore, mappings);
        boolean checkIgnore = !ignore.isEmpty() || mappings.values().stream().anyMatch(m -> m.ignore);
        XLSSpliterator xlsSpliterator = new XLSSpliterator(sheet, selection, header, url, skip, limit, checkIgnore, mappings, nullValues, skipNulls);
        return xlsSpliterator;
    }

    private static String[] getHeader(boolean hasHeader, boolean skipNulls, Row header, LoadXls.Selection selection, List<String> ignore, Map<String, LoadXls.Mapping> mapping) throws IOException {
        if (!hasHeader) {
            return null;
        }
        String[] result = new String[selection.right - selection.left];
        for (int i = selection.left; i < selection.right; ++i) {
            Cell cell = header.getCell(i);
            String value = LoadXlsHandler.getHeaderValue(skipNulls, i, cell);
            result[i - selection.left] = ignore.contains(value) || mapping.getOrDefault((Object)value, (LoadXls.Mapping)LoadXls.Mapping.EMPTY).ignore ? null : value;
        }
        return result;
    }

    private static String getHeaderValue(boolean skipNulls, int i, Cell cell) {
        boolean cellBlank;
        boolean bl = cellBlank = cell == null || cell.getStringCellValue().isBlank();
        if (cellBlank && skipNulls) {
            return "Empty__" + i;
        }
        if (cell != null) {
            return cell.getStringCellValue();
        }
        throw new IllegalStateException("Header at position " + i + " doesn't have a value");
    }

    private static Object[] extract(Row row, LoadXls.Selection selection) {
        Object[] result = new Object[selection.right - selection.left];
        for (int i = selection.left; i < selection.right; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            result[i - selection.left] = LoadXlsHandler.getValue(cell, cell.getCellType());
        }
        return result;
    }

    private static Object getValue(Cell cell, CellType type) {
        switch (type) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(cell.getDateCellValue());
                    LocalDateTime localDateTime = LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
                    return LocalDateTimeValue.localDateTime((LocalDateTime)localDateTime);
                }
                double value = cell.getNumericCellValue();
                if (value == Math.floor(value)) {
                    return (long)value;
                }
                return value;
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case FORMULA: {
                return LoadXlsHandler.getValue(cell, cell.getCachedFormulaResultType());
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case _NONE: {
                return null;
            }
            case BLANK: {
                return null;
            }
            case ERROR: {
                return null;
            }
        }
        return null;
    }

    public static class XLSSpliterator
    extends Spliterators.AbstractSpliterator<LoadXls.XLSResult> {
        private final Sheet sheet;
        private final LoadXls.Selection selection;
        private final String[] header;
        private final String url;
        private final long limit;
        private final boolean ignore;
        private final boolean skipNulls;
        private final Map<String, LoadXls.Mapping> mapping;
        private final List<Object> nullValues;
        private final long skip;
        long lineNo;

        public XLSSpliterator(Sheet sheet, LoadXls.Selection selection, String[] header, String url, long skip, long limit, boolean ignore, Map<String, LoadXls.Mapping> mapping, List<Object> nullValues, boolean skipNulls) throws IOException {
            super(Long.MAX_VALUE, 16);
            this.sheet = sheet;
            this.selection = selection;
            this.header = header;
            this.url = url;
            this.ignore = ignore;
            this.mapping = mapping;
            this.nullValues = nullValues;
            int headerOffset = header != null ? 1 : 0;
            this.skip = skip + (long)selection.getOrDefault(selection.top, sheet.getFirstRowNum()) + (long)headerOffset;
            this.limit = limit == Long.MAX_VALUE ? (long)selection.getOrDefault(selection.bottom, sheet.getLastRowNum()) : skip + limit;
            this.lineNo = this.skip;
            this.skipNulls = skipNulls;
        }

        @Override
        public boolean tryAdvance(Consumer<? super LoadXls.XLSResult> action) {
            try {
                Row row = this.sheet.getRow((int)this.lineNo);
                if (this.lineNo <= this.limit) {
                    if (row != null) {
                        Object[] list = LoadXlsHandler.extract(row, this.selection);
                        action.accept(new LoadXls.XLSResult(this.header, list, this.lineNo - this.skip, this.ignore, this.mapping, this.nullValues));
                        ++this.lineNo;
                        return true;
                    }
                    if (this.skipNulls && this.lineNo <= (long)this.sheet.getLastRowNum()) {
                        ++this.lineNo;
                        return this.tryAdvance(action);
                    }
                    return false;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading XLS from URL " + Util.cleanUrl((String)this.url) + " at " + this.lineNo, e);
            }
        }
    }
}

