/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import apoc.ApocConfig;
import apoc.ml.MixedbreadAI;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

abstract class OpenAIRequestHandler {
    private final String defaultUrl;

    public OpenAIRequestHandler(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public abstract String getApiVersion(Map<String, Object> var1, ApocConfig var2);

    public abstract void addApiKey(Map<String, Object> var1, String var2);

    public String getEndpoint(Map<String, Object> procConfig, ApocConfig apocConfig) {
        String url = (String)procConfig.getOrDefault("endpoint", apocConfig.getString("apoc.ml.openai.url", System.getProperty("apoc.ml.openai.url")));
        if (url == null) {
            return this.getDefaultUrl();
        }
        return url;
    }

    public String getFullUrl(String method, Map<String, Object> procConfig, ApocConfig apocConfig) {
        return Stream.of(this.getEndpoint(procConfig, apocConfig), method, this.getApiVersion(procConfig, apocConfig)).filter(StringUtils::isNotBlank).collect(Collectors.joining("/")).replaceAll("/\\?", "?");
    }

    static class Custom
    extends OpenAi {
        public Custom() {
            super(null);
        }

        @Override
        public String getDefaultUrl() {
            throw new RuntimeException(MixedbreadAI.ERROR_MSG_MISSING_ENDPOINT);
        }
    }

    static class Anthropic
    extends OpenAi {
        public Anthropic() {
            super("https://api.anthropic.com/v1");
        }

        @Override
        public void addApiKey(Map<String, Object> headers, String apiKey) {
            headers.put("x-api-key", apiKey);
        }
    }

    static class OpenAi
    extends OpenAIRequestHandler {
        public OpenAi(String defaultUrl) {
            super(defaultUrl);
        }

        @Override
        public String getApiVersion(Map<String, Object> configuration, ApocConfig apocConfig) {
            return "";
        }

        @Override
        public void addApiKey(Map<String, Object> headers, String apiKey) {
            headers.put("Authorization", "Bearer " + apiKey);
        }
    }

    static class Azure
    extends OpenAIRequestHandler {
        public Azure(String defaultUrl) {
            super(defaultUrl);
        }

        @Override
        public String getApiVersion(Map<String, Object> configuration, ApocConfig apocConfig) {
            return "?api-version=" + configuration.getOrDefault("apiVersion", apocConfig.getString("apoc.ml.azure.api.version"));
        }

        @Override
        public void addApiKey(Map<String, Object> headers, String apiKey) {
            headers.put("api-key", apiKey);
        }
    }

    static enum Type {
        AZURE(new Azure(null)),
        HUGGINGFACE(new OpenAi(null)),
        MIXEDBREAD_EMBEDDING(new OpenAi("https://api.mixedbread.ai/v1")),
        MIXEDBREAD_CUSTOM(new Custom()),
        ANTHROPIC(new Anthropic()),
        OPENAI(new OpenAi("https://api.openai.com/v1"));

        private final OpenAIRequestHandler handler;

        private Type(OpenAIRequestHandler handler) {
            this.handler = handler;
        }

        public OpenAIRequestHandler get() {
            return this.handler;
        }
    }
}

