/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.mongodb.MongoDBColl;
import apoc.mongodb.MongoDbConfig;
import apoc.util.Util;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.bson.Document;

public interface MongoDbCollInterface
extends Closeable {
    public Map<String, Object> first(Map<String, Object> var1);

    public Stream<Map<String, Object>> all(Map<String, Object> var1, Long var2, Long var3);

    public long count(Map<String, Object> var1);

    public long count(Document var1);

    public Stream<Map<String, Object>> aggregate(List<Document> var1);

    public Stream<Map<String, Object>> find(Map<String, Object> var1, Map<String, Object> var2, Map<String, Object> var3, Long var4, Long var5);

    public Stream<Map<String, Object>> find(Document var1, Document var2, Document var3, int var4, int var5);

    public void insert(List<Map<String, Object>> var1);

    public void insertDocs(List<Document> var1);

    public long update(Map<String, Object> var1, Map<String, Object> var2);

    public long update(Document var1, Document var2);

    public long delete(Map<String, Object> var1);

    public long delete(Document var1);

    default public void safeClose() {
        Util.close((AutoCloseable)this);
    }

    public static class Factory {
        public static MongoDbCollInterface create(String url, String db, String coll, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
            try {
                return new MongoDBColl(url, db, coll, compatibleValues, extractReferences, objectIdAsMap);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create MongoDBColl instance", e);
            }
        }

        public static MongoDbCollInterface create(String url, MongoDbConfig conf) {
            try {
                return new MongoDBColl(url, conf);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create MongoDBColl instance", e);
            }
        }
    }
}

