/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.ApocConfig;
import apoc.ExtendedApocConfig;
import apoc.ExtendedSystemLabels;
import apoc.ExtendedSystemPropertyKeys;
import apoc.Pools;
import apoc.SystemPropertyKeys;
import apoc.util.SystemDbUtil;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import apoc.uuid.UUIDHandlerNewProcedures;
import apoc.uuid.Uuid;
import apoc.uuid.UuidConfig;
import apoc.uuid.UuidUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class UuidHandler
extends LifecycleAdapter
implements TransactionEventListener<Void> {
    private final GraphDatabaseAPI db;
    private final Log log;
    private final DatabaseManagementService databaseManagementService;
    private final ApocConfig apocConfig;
    private final AtomicReference<Map<String, UuidConfig>> labelAndPropertyNamesSnapshot = new AtomicReference(Map.of());
    private final ExtendedApocConfig.UuidFormatType uuidFormat;
    private final JobScheduler jobScheduler;
    private final Pools pools;
    private JobHandle refreshUuidHandle;
    private volatile long lastUpdate;
    public static final String APOC_UUID_REFRESH = "apoc.uuid.refresh";
    public static final String NOT_ENABLED_ERROR = "UUID have not been enabled. Set 'apoc.uuid.enabled=true' or 'apoc.uuid.enabled.%s=true' in your apoc.conf file located in the $NEO4J_HOME/conf/ directory.";

    public UuidHandler(GraphDatabaseAPI db, DatabaseManagementService databaseManagementService, Log log, ApocConfig apocConfig, JobScheduler jobScheduler, Pools pools) {
        this.db = db;
        this.databaseManagementService = databaseManagementService;
        this.log = log;
        this.apocConfig = apocConfig;
        ExtendedApocConfig extendedApocConfig = ExtendedApocConfig.extendedApocConfig();
        this.uuidFormat = extendedApocConfig.getEnumProperty("apoc.uuid.format", ExtendedApocConfig.UuidFormatType.class, ExtendedApocConfig.UuidFormatType.hex);
        this.jobScheduler = jobScheduler;
        this.pools = pools;
    }

    public void start() {
        if (this.isEnabled()) {
            this.refresh();
            Integer uuidRefresh = this.apocConfig.getConfig().getInteger(APOC_UUID_REFRESH, null);
            if (uuidRefresh != null) {
                this.refreshUuidHandle = this.jobScheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, () -> {
                    if (SystemDbUtil.getLastUpdate(this.db.databaseName(), ExtendedSystemLabels.ApocUuidMeta) >= this.lastUpdate) {
                        this.refreshAndAdd();
                    }
                }, (long)uuidRefresh.intValue(), (long)uuidRefresh.intValue(), TimeUnit.MILLISECONDS);
            }
            this.databaseManagementService.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    private boolean isEnabled() {
        return UUIDHandlerNewProcedures.isEnabled(this.db.databaseName());
    }

    public void stop() {
        if (this.isEnabled()) {
            this.databaseManagementService.unregisterTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
            if (this.refreshUuidHandle != null) {
                this.refreshUuidHandle.cancel();
            }
        }
    }

    private void checkAndRestoreUuidProperty(Iterable<PropertyEntry<Node>> nodeProperties, String label, String uuidProperty, TransactionData txData) {
        this.checkAndRestoreUuidProperty(nodeProperties, label, uuidProperty, txData, null);
    }

    private void checkAndRestoreUuidProperty(Iterable<PropertyEntry<Node>> nodeProperties, String label, String uuidProperty, TransactionData txData, Predicate<PropertyEntry<Node>> predicate) {
        if (nodeProperties.iterator().hasNext()) {
            nodeProperties.forEach(nodePropertyEntry -> {
                Node entity = (Node)nodePropertyEntry.entity();
                if (txData.isDeleted(entity)) {
                    return;
                }
                if (predicate == null) {
                    if (entity.hasLabel(Label.label((String)label)) && nodePropertyEntry.key().equals(uuidProperty)) {
                        entity.setProperty(uuidProperty, nodePropertyEntry.previouslyCommittedValue());
                    }
                } else if (entity.hasLabel(Label.label((String)label)) && nodePropertyEntry.key().equals(uuidProperty) && predicate.test((PropertyEntry<Node>)nodePropertyEntry)) {
                    entity.setProperty(uuidProperty, nodePropertyEntry.previouslyCommittedValue());
                }
            });
        }
    }

    public Void beforeCommit(TransactionData txData, Transaction transaction, GraphDatabaseService databaseService) {
        Iterable assignedNodeProperties = txData.assignedNodeProperties();
        Iterable removedNodeProperties = txData.removedNodeProperties();
        this.labelAndPropertyNamesSnapshot.get().forEach((label, config) -> {
            String propertyName = config.getUuidProperty();
            List<Node> nodes = config.isAddToSetLabels() ? StreamSupport.stream(txData.assignedLabels().spliterator(), false).map(LabelEntry::node).collect(Collectors.toList()) : Iterables.asList((Iterable)txData.createdNodes());
            try {
                nodes.forEach(node -> {
                    if (node.hasLabel(Label.label((String)label)) && !node.hasProperty(propertyName)) {
                        String uuid = this.generateUuidValue();
                        node.setProperty(propertyName, (Object)uuid);
                    }
                });
                this.checkAndRestoreUuidProperty(assignedNodeProperties, (String)label, propertyName, txData, nodePropertyEntry -> nodePropertyEntry.value() == null || nodePropertyEntry.value().equals(""));
                this.checkAndRestoreUuidProperty(removedNodeProperties, (String)label, propertyName, txData);
            }
            catch (Exception e) {
                this.log.warn("Error executing uuid " + label + " in phase before", (Throwable)e);
            }
        });
        return null;
    }

    public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
    }

    public void afterRollback(TransactionData data, Void state, GraphDatabaseService databaseService) {
    }

    private void checkEnabled() {
        UUIDHandlerNewProcedures.checkEnabled(this.db.databaseName());
    }

    private String generateUuidValue() {
        UUID uuid = UUID.randomUUID();
        switch (this.uuidFormat) {
            case base64: {
                return UuidUtil.generateBase64Uuid((UUID)uuid);
            }
        }
        return uuid.toString();
    }

    public void checkConstraintUuid(Transaction tx, String label, String propertyName) {
        Schema schema = tx.schema();
        Stream<ConstraintDefinition> constraintDefinitionStream = StreamSupport.stream(schema.getConstraints(Label.label((String)label)).spliterator(), false);
        boolean exists = constraintDefinitionStream.anyMatch(constraint -> {
            Stream<String> streamPropertyKeys = StreamSupport.stream(constraint.getPropertyKeys().spliterator(), false);
            return streamPropertyKeys.anyMatch(property -> property.equals(propertyName));
        });
        if (!exists) {
            String error = String.format("`CREATE CONSTRAINT FOR (%s:%s) REQUIRE %s.%s IS UNIQUE`", label.toLowerCase(), label, label.toLowerCase(), propertyName);
            throw new RuntimeException("No constraint found for label: " + label + ", please add the constraint with the following : " + error);
        }
    }

    public void add(Transaction tx, String label, UuidConfig config) {
        this.checkEnabled();
        String propertyName = config.getUuidProperty();
        this.checkConstraintUuid(tx, label, propertyName);
        try (Transaction sysTx = this.apocConfig.getSystemDb().beginTx();){
            Node node = Util.mergeNode((Transaction)sysTx, (Label)ExtendedSystemLabels.ApocUuid, null, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.db.databaseName()), Pair.of((Object)ExtendedSystemPropertyKeys.label.name(), (Object)label), Pair.of((Object)ExtendedSystemPropertyKeys.propertyName.name(), (Object)propertyName)});
            node.setProperty(ExtendedSystemPropertyKeys.addToSetLabel.name(), (Object)config.isAddToSetLabels());
            sysTx.commit();
        }
        this.refresh();
    }

    public Map<String, UuidConfig> list() {
        this.checkEnabled();
        return this.labelAndPropertyNamesSnapshot.get();
    }

    public synchronized void refreshAndAdd() {
        long start = System.currentTimeMillis();
        Map<String, UuidConfig> localCache = this.provisionalRefresh();
        if (Util.isWriteableInstance((GraphDatabaseAPI)this.db)) {
            localCache.forEach((label, conf) -> {
                if (conf.isCreateConstraint()) {
                    try {
                        String queryConst = String.format("CREATE CONSTRAINT IF NOT EXISTS FOR (n:%s) REQUIRE (n.%s) IS UNIQUE", Util.quote((String)label), Util.quote((String)conf.getUuidProperty()));
                        this.db.executeTransactionally(queryConst);
                    }
                    catch (Exception e) {
                        this.log.error("Error during uuid constraint auto-creation: " + e.getMessage());
                    }
                    conf.setCreateConstraint(false);
                }
                if (conf.isAddToExistingNodes()) {
                    try {
                        Map<String, Object> result = Uuid.setExistingNodes((GraphDatabaseService)this.db, this.pools, label, conf);
                        String logBatchResult = String.format("Result of batch computation obtained from existing nodes for UUID handler with label `%s`: \n %s", label, result);
                        this.log.info(logBatchResult);
                    }
                    catch (Exception e) {
                        String errMsg = e.getMessage().contains("There is no procedure with the name `apoc.periodic.iterate` registered for this database instance") ? "apoc core needs to be installed when using apoc.uuid.install with the flag addToExistingNodes = true" : e.getMessage();
                        this.log.error("Error during uuid set to existing nodes: " + errMsg);
                    }
                    conf.setAddToExistingNodes(false);
                }
            });
        }
        this.labelAndPropertyNamesSnapshot.set(localCache);
        this.lastUpdate = start;
    }

    public Map<String, UuidConfig> provisionalRefresh() {
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            Map<String, UuidConfig> map = tx.findNodes((Label)ExtendedSystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).stream().collect(Collectors.toUnmodifiableMap(node -> (String)node.getProperty(ExtendedSystemPropertyKeys.label.name()), node -> new UuidConfig(Map.of("uuidProperty", node.getProperty(ExtendedSystemPropertyKeys.propertyName.name()), "addToSetLabels", node.getProperty(ExtendedSystemPropertyKeys.addToSetLabel.name(), (Object)false), "addToExistingNodes", node.getProperty(ExtendedSystemPropertyKeys.addToExistingNodes.name(), (Object)false)))));
            return map;
        }
    }

    public void refresh() {
        long start = System.currentTimeMillis();
        this.labelAndPropertyNamesSnapshot.set(this.provisionalRefresh());
        this.lastUpdate = start;
    }

    public synchronized UuidConfig remove(String label) {
        UuidConfig oldValue = this.labelAndPropertyNamesSnapshot.get().get(label);
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)ExtendedSystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), ExtendedSystemPropertyKeys.label.name(), (Object)label).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        this.refresh();
        return oldValue;
    }

    public synchronized Map<String, UuidConfig> removeAll() {
        Map<String, UuidConfig> retval = this.labelAndPropertyNamesSnapshot.get();
        this.labelAndPropertyNamesSnapshot.set(Map.of());
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)ExtendedSystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        this.refresh();
        return retval;
    }
}

