/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.Extended;
import apoc.ml.RestAPIConfig;
import apoc.result.MapResult;
import apoc.vectordb.VectorDb;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorDbUtil;
import apoc.vectordb.VectorEmbeddingConfig;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class Milvus {
    public static final VectorDbHandler DB_HANDLER = VectorDbHandler.Type.MILVUS.get();
    @Context
    public ProcedureCallContext procedureCallContext;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.vectordb.milvus.info")
    @Description(value="apoc.vectordb.milvus.info(hostOrKey, collection, $configuration) - Get information about the specified existing collection or returns a response with code 100 if it does not exist")
    public Stream<MapResult> info(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="dbName", defaultValue="default") String dbName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/describe";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.put("body", Map.of("dbName", dbName, "collectionName", collection));
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), Map.of());
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.milvus.createCollection")
    @Description(value="apoc.vectordb.milvus.createCollection(hostOrKey, collection, similarity, size, $configuration) - Creates a collection, with the name specified in the 2nd parameter, and with the specified `similarity` and `size`")
    public Stream<MapResult> createCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="similarity") String similarity, @Name(value="size") Long size, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/create";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "POST");
        Map<String, String> additionalBodies = Map.of("collectionName", collection, "dimension", size, "metricType", similarity);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.milvus.deleteCollection")
    @Description(value="apoc.vectordb.milvus.deleteCollection(hostOrKey, collection, $configuration) - Deletes a collection with the name specified in the 2nd parameter")
    public Stream<MapResult> deleteCollection(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/collections/drop";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "POST");
        Map<String, String> additionalBodies = Map.of("collectionName", collection);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.milvus.upsert")
    @Description(value="apoc.vectordb.milvus.upsert(hostOrKey, collection, vectors, $configuration) - Upserts, in the collection with the name specified in the 2nd parameter, the vectors [{id: 'id', vector: '<vectorDb>', medatada: '<metadata>'}]")
    public Stream<MapResult> upsert(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vectors") List<Map<String, Object>> vectors, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/entities/upsert";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "POST");
        List<Map> data = vectors.stream().map(i -> {
            HashMap map = new HashMap(i);
            map.putAll((Map)map.remove("metadata"));
            return map;
        }).toList();
        Map<String, String> additionalBodies = Map.of("data", data, "collectionName", collection);
        RestAPIConfig restAPIConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(restAPIConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.milvus.delete")
    @Description(value="apoc.vectordb.milvus.delete(hostOrKey, collection, ids, $configuration) - Delete the vectors with the specified `ids`")
    public Stream<MapResult> delete(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vectors") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        String url = "%s/entities/delete";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        config.putIfAbsent("method", "POST");
        String filter = "id in " + ids;
        Map<String, CallSite> additionalBodies = Map.of("collectionName", collection, "filter", filter);
        RestAPIConfig apiConfig = new RestAPIConfig(config, Map.of(), additionalBodies);
        return VectorDb.executeRequest(apiConfig, this.urlAccessChecker).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.vectordb.milvus.get")
    @Description(value="apoc.vectordb.milvus.get(hostOrKey, collection, ids, $configuration) - Get the vectors with the specified `ids`")
    public Stream<VectorDbUtil.EmbeddingResult> get(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.getCommon(hostOrKey, collection, ids, configuration);
    }

    @Procedure(value="apoc.vectordb.milvus.getAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.milvus.getAndUpdate(hostOrKey, collection, ids, $configuration) - Gets the vectors with the specified `ids`, and optionally creates/updates neo4j entities")
    public Stream<VectorDbUtil.EmbeddingResult> getAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="ids") List<Object> ids, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.getCommon(hostOrKey, collection, ids, configuration);
    }

    private Stream<VectorDbUtil.EmbeddingResult> getCommon(String hostOrKey, String collection, List<Object> ids, Map<String, Object> configuration) throws Exception {
        String url = "%s/entities/get";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromGet(config, this.procedureCallContext, ids, collection);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx, v -> this.getMapStream((Map)v));
    }

    @Procedure(value="apoc.vectordb.milvus.query")
    @Description(value="apoc.vectordb.milvus.query(hostOrKey, collection, vector, filter, limit, $configuration) - Retrieve closest vectors the the defined `vector`, `limit` of results,  in the collection with the name specified in the 2nd parameter")
    public Stream<VectorDbUtil.EmbeddingResult> query(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="null") Object filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        VectorDbUtil.setReadOnlyMappingMode(configuration);
        return this.queryCommon(hostOrKey, collection, vector, filter, limit, configuration);
    }

    @Procedure(value="apoc.vectordb.milvus.queryAndUpdate", mode=Mode.WRITE)
    @Description(value="apoc.vectordb.milvus.queryAndUpdate(hostOrKey, collection, vector, filter, limit, $configuration) - Retrieve closest vectors the the defined `vector`, `limit` of results,  in the collection with the name specified in the 2nd parameter")
    public Stream<VectorDbUtil.EmbeddingResult> queryAndUpdate(@Name(value="hostOrKey") String hostOrKey, @Name(value="collection") String collection, @Name(value="vector", defaultValue="[]") List<Double> vector, @Name(value="filter", defaultValue="null") Object filter, @Name(value="limit", defaultValue="10") long limit, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return this.queryCommon(hostOrKey, collection, vector, filter, limit, configuration);
    }

    private Stream<Map> getMapStream(Map v) {
        Object data = v.get("data");
        return ((List)data).stream().map(i -> {
            HashMap metadata = new HashMap(i);
            metadata.remove("id");
            metadata.remove("vector");
            metadata.remove("distance");
            i.put("metadata", metadata);
            return i;
        });
    }

    private Stream<VectorDbUtil.EmbeddingResult> queryCommon(String hostOrKey, String collection, List<Double> vector, Object filter, long limit, Map<String, Object> configuration) throws Exception {
        String url = "%s/entities/search";
        Map<String, Object> config = this.getVectorDbInfo(hostOrKey, collection, configuration, url);
        VectorEmbeddingConfig conf = DB_HANDLER.getEmbedding().fromQuery(config, this.procedureCallContext, vector, filter, limit, collection);
        return VectorDb.getEmbeddingResultStream(conf, this.procedureCallContext, this.urlAccessChecker, this.tx, v -> this.getMapStream((Map)v));
    }

    private Map<String, Object> getVectorDbInfo(String hostOrKey, String collection, Map<String, Object> configuration, String templateUrl) {
        return VectorDbUtil.getCommonVectorDbInfo(hostOrKey, collection, configuration, templateUrl, DB_HANDLER);
    }
}

