/*
 * Decompiled with CFR 0.152.
 */
package apoc.vectordb;

import apoc.ml.RestAPIConfig;
import apoc.util.MapUtil;
import apoc.vectordb.VectorDbHandler;
import apoc.vectordb.VectorEmbeddingConfig;
import apoc.vectordb.VectorEmbeddingHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

public class PineconeHandler
implements VectorDbHandler {
    @Override
    public String getUrl(String hostOrKey) {
        return StringUtils.isBlank((CharSequence)hostOrKey) ? "https://api.pinecone.io" : hostOrKey;
    }

    @Override
    public VectorEmbeddingHandler getEmbedding() {
        return new PineconeEmbeddingHandler();
    }

    @Override
    public String getLabel() {
        return "Pinecone";
    }

    @Override
    public Map<String, Object> getCredentials(Object credentialsObj, Map<String, Object> config) {
        Map headers = config.getOrDefault("headers", new HashMap());
        headers.putIfAbsent("Api-Key", credentialsObj);
        config.put("headers", headers);
        return config;
    }

    static class PineconeEmbeddingHandler
    implements VectorEmbeddingHandler {
        PineconeEmbeddingHandler() {
        }

        @Override
        public <T> VectorEmbeddingConfig fromGet(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<T> ids, String index) {
            List<String> fields = procedureCallContext.outputFields().toList();
            config.put("body", null);
            Object endpoint = (String)config.get("endpoint");
            if (!((String)endpoint).contains("ids=")) {
                String idsQueryUrl = ids.stream().map(i -> "ids=" + i).collect(Collectors.joining("&"));
                endpoint = ((String)endpoint).contains("?") ? (String)endpoint + "&" + idsQueryUrl : (String)endpoint + "?" + idsQueryUrl;
            }
            config.put("endpoint", endpoint);
            return this.getVectorEmbeddingConfig(config, fields, MapUtil.map((Object[])new Object[0]));
        }

        @Override
        public VectorEmbeddingConfig fromQuery(Map<String, Object> config, ProcedureCallContext procedureCallContext, List<Double> vector, Object filter, long limit, String index) {
            List<String> fields = procedureCallContext.outputFields().toList();
            Map additionalBodies = MapUtil.map((Object[])new Object[]{"vector", vector, "filter", filter, "topK", limit});
            return this.getVectorEmbeddingConfig(config, fields, additionalBodies);
        }

        private VectorEmbeddingConfig getVectorEmbeddingConfig(Map<String, Object> config, List<String> fields, Map<String, Object> additionalBodies) {
            config.putIfAbsent("vectorKey", "values");
            VectorEmbeddingConfig conf = new VectorEmbeddingConfig(config);
            additionalBodies.put("includeMetadata", fields.contains("metadata"));
            additionalBodies.put("includeValues", fields.contains("vector") && conf.isAllResults());
            RestAPIConfig apiConfig = conf.getApiConfig();
            Map<String, Object> headers = apiConfig.getHeaders();
            headers.remove("method");
            apiConfig.setHeaders(headers);
            return this.populateApiBodyRequest(conf, additionalBodies);
        }
    }
}

