/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.util.TestContainerUtil;
import apoc.util.collection.Iterables;
import apoc.util.collection.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;

public class CypherTestUtil {
    public static final String CREATE_RETURNQUERY_NODES = "UNWIND range(0,3) as id \nCREATE (n:ReturnQuery {id:id})-[:REL {idRel: id}]->(:Other {idOther: id})";
    public static final String CREATE_RESULT_NODES = "UNWIND range(0,3) as id \nCREATE (n:Result {id:id})-[:REL {idRel: id}]->(:Other {idOther: id})";
    public static String SET_NODE = "MATCH (n:Result)-[:REL]->(:Other)\nSET n.updated = true\nRETURN n;\n";
    public static String SET_AND_RETURN_QUERIES = "MATCH (n:Result)-[:REL]->(:Other)\nSET n.updated = true\nRETURN n;\n\nMATCH (n:Result)-[rel:REL]->(o:Other)\nSET rel.updated = 1\nRETURN n, o, collect(rel) AS rels;\n\nMATCH (n:Result)-[rel:REL]->(o:Other)\nSET o.updated = 'true'\nRETURN collect(n) as nodes, collect(rel) as rels, collect(o) as others;\n";
    public static String SIMPLE_RETURN_QUERIES = "MATCH (n:ReturnQuery) RETURN n ORDER BY n.id";

    public static void testRunProcedureWithSimpleReturnResults(Session session, String query, Map<String, Object> params) {
        session.writeTransaction(tx -> tx.run(CREATE_RETURNQUERY_NODES));
        session.readTransaction(tx -> {
            List result = tx.run("MATCH (n:ReturnQuery) RETURN n.id").list();
            System.out.println("DEBUG: testRunProcedureWithSimpleReturnResults");
            System.out.println("DEBUG: " + result.size());
            for (Record r : result) {
                System.out.println("DEBUG: " + r);
            }
            tx.commit();
            return null;
        });
        TestContainerUtil.testResult(session, query, params, r -> {
            Map row = (Map)r.next();
            CypherTestUtil.assertReturnQueryNode(row, 0L);
            row = (Map)r.next();
            CypherTestUtil.assertReturnQueryNode(row, 1L);
            row = (Map)r.next();
            CypherTestUtil.assertReturnQueryNode(row, 2L);
            row = (Map)r.next();
            CypherTestUtil.assertReturnQueryNode(row, 3L);
            row = (Map)r.next();
            CypherTestUtil.assertReadOnlyResult(row);
            Assert.assertFalse((boolean)r.hasNext());
        });
    }

    public static void assertReadOnlyResult(Map<String, Object> row) {
        Map result = (Map)row.get("result");
        Assert.assertEquals((Object)-1L, (Object)row.get("row"));
        Assert.assertEquals((long)0L, (long)((Long)result.get("nodesCreated")));
        Assert.assertEquals((long)0L, (long)((Long)result.get("propertiesSet")));
    }

    private static void assertReturnQueryNode(Map<String, Object> row, long id) {
        System.out.println("DEBUG: " + row);
        Assert.assertEquals((Object)id, (Object)row.get("row"));
        Map result = (Map)row.get("result");
        Assert.assertEquals((long)1L, (long)result.size());
        CypherTestUtil.assertReturnQueryNode(id, result);
    }

    public static void assertReturnQueryNode(long id, Map<String, Node> result) {
        Node n = result.get("n");
        Assert.assertEquals(List.of("ReturnQuery"), (Object)Iterables.asList((Iterable)n.labels()));
        Assert.assertEquals(Map.of("id", id), (Object)n.asMap());
    }

    public static void testRunProcedureWithSetAndReturnResults(Session session, String query, Map<String, Object> params) {
        session.writeTransaction(tx -> tx.run(CREATE_RESULT_NODES));
        TestContainerUtil.testResult(session, query, params, r -> {
            Map row = (Map)r.next();
            CypherTestUtil.assertRunProcNode(row, 0L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcNode(row, 1L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcNode(row, 2L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcNode(row, 3L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcStatistics(row);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcRel(row, 0L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcRel(row, 1L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcRel(row, 2L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcRel(row, 3L);
            row = (Map)r.next();
            CypherTestUtil.assertRunProcStatistics(row);
            row = (Map)r.next();
            Assert.assertEquals((Object)0L, row.get("row"));
            Map result = (Map)row.get("result");
            Assert.assertEquals((long)3L, (long)result.size());
            List rels = (List)result.get("rels");
            List nodes = (List)result.get("nodes");
            List others = (List)result.get("others");
            Assert.assertEquals((long)4L, (long)rels.size());
            Assert.assertEquals((long)4L, (long)nodes.size());
            Assert.assertEquals((long)4L, (long)others.size());
            row = (Map)r.next();
            CypherTestUtil.assertRunProcStatistics(row);
            Assert.assertFalse((boolean)r.hasNext());
        });
        TestContainerUtil.testResult(session, "MATCH p=(:Result {updated:true})-[:REL {updated: 1}]->(:Other {updated: 'true'}) RETURN *", r -> Assert.assertEquals((long)4L, (long)Iterators.count((Iterator)r)));
    }

    private static void assertRunProcStatistics(Map<String, Object> row) {
        Map result = (Map)row.get("result");
        Assert.assertEquals((Object)-1L, (Object)row.get("row"));
        Assert.assertEquals((long)0L, (long)((Long)result.get("nodesCreated")));
        Assert.assertEquals((long)4L, (long)((Long)result.get("propertiesSet")));
    }

    private static void assertRunProcNode(Map<String, Object> row, long id) {
        Assert.assertEquals((Object)id, (Object)row.get("row"));
        Map result = (Map)row.get("result");
        Assert.assertEquals((long)1L, (long)result.size());
        CypherTestUtil.assertResultNode(id, result);
    }

    public static void assertResultNode(long id, Map<String, Node> result) {
        Node n = result.get("n");
        Assert.assertEquals(List.of("Result"), (Object)Iterables.asList((Iterable)n.labels()));
        Assert.assertEquals(Map.of("id", id, "updated", true), (Object)n.asMap());
    }

    private static void assertRunProcRel(Map<String, Object> row, long id) {
        Assert.assertEquals((Object)id, (Object)row.get("row"));
        Map result = (Map)row.get("result");
        Assert.assertEquals((long)3L, (long)result.size());
        List n = (List)result.get("rels");
        Assert.assertEquals((long)1L, (long)n.size());
        Assert.assertEquals((Object)"REL", (Object)((Relationship)n.get(0)).type());
        Assert.assertEquals(Map.of("idRel", id, "updated", 1L), (Object)((Relationship)n.get(0)).asMap());
    }
}

