/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.util.TransactionTestUtil;
import apoc.util.collection.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DbmsRule;

public class PeriodicTestUtils {
    public static void killPeriodicQueryAsync(DbmsRule db) {
        new Thread(() -> {
            int retries = 10;
            try {
                while (retries-- > 0 && !PeriodicTestUtils.terminateQuery("apoc.periodic", db)) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    public static boolean terminateQuery(String pattern, GraphDatabaseAPI db) {
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        KernelTransactions kernelTransactions = (KernelTransactions)dependencyResolver.resolveDependency(KernelTransactions.class);
        long numberOfKilledTransactions = kernelTransactions.activeTransactions().stream().filter(kernelTransactionHandle -> kernelTransactionHandle.executingQuery().map(query -> query.rawQueryText().contains(pattern)).orElse(false)).map(kernelTransactionHandle -> kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated)).count();
        return numberOfKilledTransactions > 0L;
    }

    public static void testTerminatePeriodicQuery(DbmsRule db, String periodicQuery) {
        PeriodicTestUtils.killPeriodicQueryAsync(db);
        PeriodicTestUtils.checkPeriodicTerminated(db, periodicQuery);
    }

    public static void testTerminateWithCommand(DbmsRule db, String periodicQuery, String iterateQuery) {
        long timeBefore = System.currentTimeMillis();
        TransactionTestUtil.terminateTransactionAsync((GraphDatabaseService)db, 10L, iterateQuery);
        PeriodicTestUtils.checkPeriodicTerminated(db, periodicQuery);
        TransactionTestUtil.lastTransactionChecks((GraphDatabaseService)db, periodicQuery, timeBefore);
    }

    private static void checkPeriodicTerminated(DbmsRule db, String periodicQuery) {
        try {
            org.neo4j.test.assertion.Assert.assertEventually(() -> (Boolean)db.executeTransactionally(periodicQuery, Map.of(), result -> {
                Map row = (Map)Iterators.single((Iterator)result);
                return (boolean)((Boolean)row.get("wasTerminated"));
            }), value -> value, (long)15L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception tfe) {
            Assert.assertTrue((String)tfe.getMessage(), (boolean)tfe.getMessage().contains("terminated"));
        }
    }
}

