/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.TestContainerUtil;
import java.io.InputStream;
import java.time.Duration;
import java.util.Scanner;
import java.util.function.Consumer;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.ext.ScriptUtils;

public class Neo4jContainerExtension
extends Neo4jContainer<Neo4jContainerExtension> {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jContainerExtension.class);
    private Session session;
    private Driver driver;
    private String filePath;
    private boolean withDriver = true;
    private boolean isRunning = false;

    public Neo4jContainerExtension() {
    }

    public Neo4jContainerExtension(String dockerImage) {
        this.setDockerImageName(dockerImage);
    }

    public Neo4jContainerExtension withInitScript(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public Neo4jContainerExtension withoutDriver() {
        this.withDriver = false;
        return this;
    }

    public void start() {
        try {
            super.start();
            if (this.withDriver) {
                this.driver = GraphDatabase.driver((String)this.getBoltUrl(), (AuthToken)this.getAuth());
                this.session = this.driver.session();
                if (this.filePath != null && !this.filePath.isEmpty()) {
                    this.executeScript(this.filePath);
                }
            }
            this.isRunning = true;
        }
        catch (Exception startException) {
            try {
                System.out.println(this.execInContainer(new String[]{"cat", "logs/debug.log"}).toString());
                System.out.println(this.execInContainer(new String[]{"cat", "logs/http.log"}).toString());
                System.out.println(this.execInContainer(new String[]{"cat", "logs/security.log"}).toString());
            }
            catch (Exception ex) {
                startException.addSuppressed(new RuntimeException("Exception during fallback execInContainer", ex));
            }
            throw startException;
        }
    }

    private void executeScript(String filePath) {
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        if (resource == null) {
            this.logger().warn("Could not load classpath init script: {}", (Object)filePath);
            throw new ScriptUtils.ScriptLoadException("Could not load classpath init script: " + filePath + ". Resource not found.");
        }
        try (Scanner scanner = new Scanner(resource).useDelimiter(";");){
            while (scanner.hasNext()) {
                String statement = scanner.next().trim();
                if (statement.isEmpty()) continue;
                this.session.writeTransaction(tx -> {
                    tx.run(statement);
                    tx.commit();
                    return null;
                });
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Driver getDriver() {
        return this.driver;
    }

    private AuthToken getAuth() {
        return this.getAdminPassword() != null && !this.getAdminPassword().isEmpty() ? AuthTokens.basic((String)"neo4j", (String)this.getAdminPassword()) : AuthTokens.none();
    }

    public Neo4jContainerExtension withLogging() {
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(logger));
        return this;
    }

    public Neo4jContainerExtension withDebugger() {
        this.withExposedPorts(new Integer[]{5005});
        this.withEnv("NEO4J_dbms_jvm_additional", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=0.0.0.0:5005");
        return this;
    }

    private Neo4jContainerExtension withWaitForDatabaseReady(String username, String password, String database, Duration timeout, TestContainerUtil.Neo4jVersion version) {
        if (version == TestContainerUtil.Neo4jVersion.ENTERPRISE) {
            this.setWaitStrategy(Wait.forHttp((String)("/db/" + database + "/cluster/available")).withBasicCredentials(username, password).forPort(7474).forStatusCodeMatching(t -> {
                logger.debug("/db/" + database + "/cluster/available [" + t.toString() + "]");
                return t == 200;
            }).withReadTimeout(Duration.ofSeconds(3L)).withStartupTimeout(timeout));
        } else {
            this.setWaitStrategy(Wait.forHttp((String)"/").forPort(7474).forStatusCodeMatching(t -> {
                logger.debug("/ [" + t.toString() + "]");
                return t == 200;
            }).withReadTimeout(Duration.ofSeconds(3L)).withStartupTimeout(timeout));
        }
        return this;
    }

    public Neo4jContainerExtension withWaitForNeo4jDatabaseReady(String password, TestContainerUtil.Neo4jVersion version) {
        return this.withWaitForDatabaseReady("neo4j", password, "neo4j", Duration.ofSeconds(300L), version);
    }

    public void stop() {
        if (this.withDriver) {
            Neo4jContainerExtension.closeSafely((AutoCloseable)this.session);
            Neo4jContainerExtension.closeSafely((AutoCloseable)this.driver);
        }
        super.stop();
    }

    private static void closeSafely(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return super.isRunning() && this.isRunning;
    }
}

