/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.collection.Iterables;
import apoc.util.collection.Iterators;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class TestUtil {
    public static void testCall(GraphDatabaseService db, String call, Consumer<Map<String, Object>> consumer) {
        TestUtil.testCall(db, call, null, consumer);
    }

    public static void testCall(GraphDatabaseService db, String call, Map<String, Object> params, Consumer<Map<String, Object>> consumer) {
        TestUtil.testResult(db, call, params, res -> {
            try {
                TestUtil.testCallAssertions(res, consumer);
            }
            catch (Throwable t) {
                TestUtil.printFullStackTrace(t);
                throw t;
            }
        });
    }

    public static void testCallCountEventually(GraphDatabaseService db, String call, int expected, long timeout) {
        TestUtil.testCallCountEventually(db, call, Collections.emptyMap(), expected, timeout);
    }

    public static void testCallCountEventually(GraphDatabaseService db, String call, Map<String, Object> params, int expected, long timeout) {
        org.neo4j.test.assertion.Assert.assertEventually(() -> TestUtil.count(db, call, params), val -> val == (long)expected, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
    }

    public static void testCallEventually(GraphDatabaseService db, String call, Consumer<Map<String, Object>> consumer, long timeout) {
        TestUtil.testCallEventually(db, call, Collections.emptyMap(), consumer, timeout);
    }

    public static void testCallEventually(GraphDatabaseService db, String call, Map<String, Object> params, Consumer<Map<String, Object>> consumer, long timeout) {
        org.neo4j.test.assertion.Assert.assertEventually(() -> (Boolean)db.executeTransactionally(call, params, r -> {
            TestUtil.testCallAssertions(r, consumer);
            return true;
        }), v -> v, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
    }

    public static void testCallAssertions(Result res, Consumer<Map<String, Object>> consumer) {
        Assert.assertTrue((String)"Should have an element", (boolean)res.hasNext());
        Map row = res.next();
        consumer.accept(row);
        Assert.assertFalse((String)"Should not have a second element", (boolean)res.hasNext());
    }

    public static void printFullStackTrace(Throwable e) {
        Object padding = "";
        while (e != null) {
            if (e.getCause() == null) {
                System.err.println((String)padding + e.getMessage());
                for (StackTraceElement element : e.getStackTrace()) {
                    if (element.getClassName().matches("^(org.junit|org.apache.maven|sun.reflect|apoc.util.TestUtil|scala.collection|java.lang.reflect|org.neo4j.cypher.internal|org.neo4j.kernel.impl.proc|sun.net|java.net).*")) continue;
                    System.err.println((String)padding + element.toString());
                }
            }
            e = e.getCause();
            padding = (String)padding + "    ";
        }
    }

    public static void testCallEmpty(GraphDatabaseService db, String call, Map<String, Object> params) {
        TestUtil.testResult(db, call, params, res -> Assert.assertFalse((String)"Expected no results", (boolean)res.hasNext()));
    }

    public static long count(GraphDatabaseService db, String cypher, Map<String, Object> params) {
        return (Long)db.executeTransactionally(cypher, params, result -> Iterators.count((Iterator)result));
    }

    public static long count(GraphDatabaseService db, String cypher) {
        return TestUtil.count(db, cypher, Collections.emptyMap());
    }

    public static void testCallCount(GraphDatabaseService db, String call, int expected) {
        TestUtil.testCallCount(db, call, Collections.emptyMap(), expected);
    }

    public static void testCallCount(GraphDatabaseService db, String call, Map<String, Object> params, int expected) {
        long count = TestUtil.count(db, call, params);
        Assert.assertEquals((String)("expected " + expected + " results, got " + count), (long)expected, (long)count);
    }

    public static void testFail(GraphDatabaseService db, String call, Class<? extends Exception> t) {
        try {
            TestUtil.testResult(db, call, null, r -> {
                while (r.hasNext()) {
                    r.next();
                }
                r.close();
            });
            Assert.fail((String)("Didn't fail with " + t.getSimpleName()));
        }
        catch (Exception e) {
            Throwable inner = e;
            boolean found = false;
            do {
                found |= t.isInstance(inner);
            } while ((inner = inner.getCause()) != null && inner.getCause() != inner);
            Assert.assertTrue((String)("Didn't fail with " + t.getSimpleName() + " but " + e.getClass().getSimpleName() + " " + e.getMessage()), (boolean)found);
        }
    }

    public static void assertError(Exception e, String errorMessage, Class<? extends Exception> exceptionType, String apocProcedure) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        Assert.assertTrue((String)(apocProcedure + " should throw an instance of " + exceptionType.getSimpleName()), (boolean)exceptionType.isInstance(rootCause));
        Assert.assertEquals((String)(apocProcedure + " should throw the following message "), (Object)errorMessage, (Object)rootCause.getMessage());
    }

    public static void testResult(GraphDatabaseService db, String call, Consumer<Result> resultConsumer) {
        TestUtil.testResult(db, call, null, resultConsumer);
    }

    public static void testResult(GraphDatabaseService db, String call, Map<String, Object> params, Consumer<Result> resultConsumer) {
        try (Transaction tx = db.beginTx();){
            Map<Object, Object> p = params == null ? Collections.emptyMap() : params;
            Result result = tx.execute(call, p);
            resultConsumer.accept(result);
            tx.commit();
        }
    }

    public static void registerProcedure(GraphDatabaseService db, Class<?> ... procedures) {
        GlobalProcedures globalProcedures = (GlobalProcedures)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(GlobalProcedures.class);
        for (Class<?> procedure : procedures) {
            try {
                globalProcedures.registerProcedure(procedure);
                globalProcedures.registerFunction(procedure);
                globalProcedures.registerAggregationFunction(procedure);
            }
            catch (KernelException e) {
                throw new RuntimeException("while registering " + procedure, e);
            }
        }
    }

    public static boolean hasCauses(Throwable t, Class<? extends Throwable> ... types) {
        if (TestUtil.anyInstance(t, types)) {
            return true;
        }
        while (t != null && t.getCause() != t) {
            if (TestUtil.anyInstance(t, types)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    private static boolean anyInstance(Throwable t, Class<? extends Throwable>[] types) {
        for (Class<? extends Throwable> type : types) {
            if (!type.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static void ignoreException(Runnable runnable, Class<? extends Throwable> ... causes) {
        try {
            runnable.run();
        }
        catch (Throwable x) {
            if (TestUtil.hasCauses(x, causes)) {
                System.err.println("Ignoring Exception " + x + ": " + x.getMessage() + " due to causes " + Arrays.toString(causes));
            }
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T assertDuration(Matcher<? super Long> matcher, Supplier<T> function) {
        long start = System.currentTimeMillis();
        T result = null;
        try {
            result = function.get();
            return result;
        }
        finally {
            Assert.assertThat((String)("duration " + matcher), (Object)(System.currentTimeMillis() - start), matcher);
            return result;
        }
    }

    public static boolean isRunningInCI() {
        return "true".equals(System.getenv("CI")) || System.getenv("TEAMCITY_VERSION") != null;
    }

    public static URL getUrlFileName(String filename) {
        return Thread.currentThread().getContextClassLoader().getResource(filename);
    }

    public static String readFileToString(File file) {
        return TestUtil.readFileToString(file, Charset.forName("UTF-8"));
    }

    public static String readFileToString(File file, Charset charset) {
        try {
            return Files.toString((File)file, (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> ResourceIterator<T> iteratorSingleColumn(Result result) {
        return result.columnAs((String)Iterables.single((Iterable)result.columns()));
    }

    public static <T> T singleResultFirstColumn(GraphDatabaseService db, String cypher) {
        return TestUtil.singleResultFirstColumn(db, cypher, Collections.emptyMap());
    }

    public static <T> T singleResultFirstColumn(GraphDatabaseService db, String cypher, Map<String, Object> params) {
        return (T)db.executeTransactionally(cypher, params, result -> Iterators.singleOrNull(TestUtil.iteratorSingleColumn(result)));
    }

    public static <T> List<T> firstColumn(GraphDatabaseService db, String cypher) {
        return (List)db.executeTransactionally(cypher, Collections.emptyMap(), result -> Iterators.asList(TestUtil.iteratorSingleColumn(result)));
    }

    public static void waitDbsAvailable(GraphDatabaseService ... dbs) {
        TestUtil.waitDbsAvailable(5000L, dbs);
    }

    public static void waitDbsAvailable(long timeout, GraphDatabaseService ... dbs) {
        Stream.of(dbs).forEach(db -> Assert.assertTrue((boolean)db.isAvailable(timeout)));
    }
}

