/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.Neo4jContainerExtension;
import apoc.util.TestContainerUtil;
import apoc.util.TestUtil;
import java.net.URI;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.SocatContainer;

public class TestcontainersCausalCluster {
    private static int MINUTES_TO_WAIT = 5;
    private static final int DEFAULT_BOLT_PORT = 7687;
    private final List<Neo4jContainerExtension> clusterMembers;
    private final SocatContainer sidecar;
    private Driver driver;
    private Session session;

    private static Stream<Map.Entry<Integer, String>> iterateMembers(int numOfMembers, ClusterInstanceType instanceType) {
        IntFunction<String> generateInstanceName = i -> String.format("neo4j-%s-%d", instanceType.toString(), i);
        return IntStream.rangeClosed(1, numOfMembers).mapToObj(i -> new AbstractMap.SimpleEntry<Integer, String>(i - 1, (String)generateInstanceName.apply(i)));
    }

    public static TestcontainersCausalCluster create(List<TestContainerUtil.ApocPackage> apocPackages, int numberOfCoreMembers, int numberOfReadReplica, Duration timeout, Map<String, Object> neo4jConfig, Map<String, String> envSettings) {
        if (numberOfCoreMembers < 3) {
            throw new IllegalArgumentException("numberOfCoreMembers must be >= 3");
        }
        if (numberOfReadReplica < 0) {
            throw new IllegalArgumentException("numberOfReadReplica must be >= 0");
        }
        String initialDiscoveryMembers = TestcontainersCausalCluster.iterateMembers(numberOfCoreMembers, ClusterInstanceType.CORE).map(n -> String.format("%s:5000", n.getValue())).collect(Collectors.joining(","));
        Network network = Network.newNetwork();
        SocatContainer proxy = (SocatContainer)new SocatContainer().withNetwork(network);
        TestcontainersCausalCluster.iterateMembers(numberOfCoreMembers, ClusterInstanceType.CORE).forEach(member -> proxy.withTarget(ClusterInstanceType.CORE.port + (Integer)member.getKey(), (String)member.getValue(), 7687));
        TestcontainersCausalCluster.iterateMembers(numberOfReadReplica, ClusterInstanceType.READ_REPLICA).forEach(member -> proxy.withTarget(ClusterInstanceType.READ_REPLICA.port + (Integer)member.getKey(), (String)member.getValue(), 7687));
        proxy.start();
        List<Neo4jContainerExtension> members = TestcontainersCausalCluster.iterateMembers(numberOfCoreMembers, ClusterInstanceType.CORE).map(member -> (Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)TestcontainersCausalCluster.createInstance(apocPackages, (String)member.getValue(), ClusterInstanceType.CORE, network, initialDiscoveryMembers, neo4jConfig, envSettings).withNeo4jConfig("initial.dbms.default_primaries_count", Integer.toString(numberOfCoreMembers))).withNeo4jConfig("dbms.default_advertised_address", (String)member.getValue())).withNeo4jConfig("dbms.connector.bolt.advertised_address", String.format("%s:%d", proxy.getContainerIpAddress(), proxy.getMappedPort(ClusterInstanceType.CORE.port + (Integer)member.getKey())))).collect(Collectors.toList());
        members.addAll(TestcontainersCausalCluster.iterateMembers(numberOfReadReplica, ClusterInstanceType.READ_REPLICA).map(member -> (Neo4jContainerExtension)((Neo4jContainerExtension)TestcontainersCausalCluster.createInstance(apocPackages, (String)member.getValue(), ClusterInstanceType.READ_REPLICA, network, initialDiscoveryMembers, neo4jConfig, envSettings).withNeo4jConfig("dbms.default_advertised_address", (String)member.getValue())).withNeo4jConfig("dbms.connector.bolt.advertised_address", String.format("%s:%d", proxy.getContainerIpAddress(), proxy.getMappedPort(ClusterInstanceType.READ_REPLICA.port + (Integer)member.getKey())))).collect(Collectors.toList()));
        CountDownLatch latch = new CountDownLatch(numberOfCoreMembers + numberOfReadReplica);
        members.forEach(instance -> CompletableFuture.runAsync(() -> {
            instance.start();
            latch.countDown();
        }));
        try {
            latch.await(MINUTES_TO_WAIT, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new TestcontainersCausalCluster(members, proxy);
    }

    private static Neo4jContainerExtension createInstance(List<TestContainerUtil.ApocPackage> apocPackages, String name, ClusterInstanceType instanceType, Network network, String initialDiscoveryMembers, Map<String, Object> neo4jConfig, Map<String, String> envSettings) {
        Neo4jContainerExtension container = (Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)((Neo4jContainerExtension)TestContainerUtil.createEnterpriseDB(apocPackages, !TestUtil.isRunningInCI()).withLabel("memberType", instanceType.toString())).withNetwork(network)).withNetworkAliases(new String[]{name})).withCreateContainerCmdModifier(cmd -> cmd.withHostName(name))).withNeo4jConfig("dbms.mode", instanceType.toString())).withNeo4jConfig("dbms.default_listen_address", "0.0.0.0")).withNeo4jConfig("causal_clustering.leadership_balancing", "NO_BALANCING")).withNeo4jConfig("causal_clustering.initial_discovery_members", initialDiscoveryMembers)).withStartupTimeout(Duration.ofMinutes(MINUTES_TO_WAIT));
        if (TestcontainersCausalCluster.withRoutingEnabled(envSettings)) {
            ((Neo4jContainerExtension)((Neo4jContainerExtension)container.withEnv("NEO4J_dbms_routing_listen__address", "0.0.0.0:7618")).withEnv("NEO4J_dbms_routing_default__router", "SERVER")).withEnv("NEO4J_dbms_routing_advertised__address", name + ":7618");
        } else {
            container.withoutDriver();
        }
        neo4jConfig.forEach((conf, value) -> container.withNeo4jConfig((String)conf, String.valueOf(value)));
        container.withEnv(envSettings);
        return container;
    }

    private static boolean withRoutingEnabled(Map<String, String> envSettings) {
        return "true".equals(envSettings.get("NEO4J_dbms_routing_enabled"));
    }

    public TestcontainersCausalCluster(List<Neo4jContainerExtension> clusterMembers, SocatContainer sidecars) {
        this.clusterMembers = clusterMembers;
        this.sidecar = sidecars;
        this.driver = GraphDatabase.driver((URI)this.getURI(), (AuthToken)AuthTokens.basic((String)"neo4j", (String)"apoc12345"));
        this.session = this.driver.session();
    }

    public List<Neo4jContainerExtension> getClusterMembers() {
        return this.clusterMembers;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public Session getSession() {
        return this.session;
    }

    public URI getURI() {
        return Optional.of(this.sidecar).map(instance -> String.format("neo4j://%s:%d", instance.getContainerIpAddress(), instance.getMappedPort(7687))).map(URI::create).orElseThrow(() -> new IllegalStateException("No sidecar as entrypoint into the cluster available."));
    }

    public void close() {
        this.getSession().close();
        this.getDriver().close();
        this.sidecar.stop();
        this.clusterMembers.forEach(Neo4jContainerExtension::stop);
    }

    public static enum ClusterInstanceType {
        CORE(7687),
        READ_REPLICA(8687);

        private final int port;

        private ClusterInstanceType(int port) {
            this.port = port;
        }
    }
}

