/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.MapUtil;
import apoc.util.TestUtil;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;

public class TransactionTestUtil {
    public static final String TRANSACTION_LIST = "SHOW TRANSACTIONS";
    public static final long DEFAULT_TIMEOUT = 10L;

    public static void checkTerminationGuard(GraphDatabaseService db, String query) {
        TransactionTestUtil.checkTerminationGuard(db, query, Collections.emptyMap());
    }

    public static void checkTerminationGuard(GraphDatabaseService db, long timeout, String query) {
        TransactionTestUtil.checkTerminationGuard(db, timeout, query, Collections.emptyMap());
    }

    public static void checkTerminationGuard(GraphDatabaseService db, String query, Map<String, Object> params) {
        TransactionTestUtil.checkTerminationGuard(db, 10L, query, params);
    }

    public static void checkTerminationGuard(GraphDatabaseService db, long timeout, String query, Map<String, Object> params) {
        TransactionTestUtil.terminateTransactionAsync(db, timeout, query);
        long timePassed = System.currentTimeMillis();
        try (Transaction transaction = db.beginTx(timeout, TimeUnit.SECONDS);){
            transaction.execute(query, params).resultAsString();
            transaction.commit();
            Assert.fail((String)"Should fail because of TransactionFailureException");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)("Actual message is: " + msg), (boolean)Stream.of("terminated", "failed", "closed").anyMatch(msg::contains));
        }
        TransactionTestUtil.lastTransactionChecks(db, timeout, query, timePassed);
    }

    public static void lastTransactionChecks(GraphDatabaseService db, long timeout, String query, long timePassed) {
        TransactionTestUtil.checkTransactionTime(timeout, timePassed);
        TransactionTestUtil.checkTransactionNotInList(db, query);
    }

    public static void lastTransactionChecks(GraphDatabaseService db, String query, long timeBefore) {
        TransactionTestUtil.lastTransactionChecks(db, 10L, query, timeBefore);
    }

    public static void checkTransactionTime(long timeout, long timePassed) {
        timePassed = (System.currentTimeMillis() - timePassed) / 1000L;
        Assert.assertTrue((String)("The transaction hasn't been terminated before the timeout time, but after " + timePassed + " seconds"), (timePassed <= timeout ? 1 : 0) != 0);
    }

    public static void checkTransactionNotInList(GraphDatabaseService db, String query) {
        TestUtil.testResult(db, TRANSACTION_LIST, MapUtil.map((Object[])new Object[]{"query", query}), result -> {
            boolean currentQuery = result.columnAs("currentQuery").stream().noneMatch(currQuery -> currQuery.equals(query));
            Assert.assertTrue((boolean)currentQuery);
        });
    }

    public static void terminateTransactionAsync(GraphDatabaseService db, String query) {
        TransactionTestUtil.terminateTransactionAsync(db, 10L, query);
    }

    public static void terminateTransactionAsync(GraphDatabaseService db, long timeout, String query) {
        new Thread(() -> {
            String[] transactionId = new String[1];
            org.neo4j.test.assertion.Assert.assertEventually(() -> (Boolean)db.executeTransactionally("SHOW TRANSACTIONS YIELD currentQuery, transactionId WHERE currentQuery CONTAINS $query AND NOT currentQuery STARTS WITH $transactionList RETURN transactionId", MapUtil.map((Object[])new Object[]{"query", query, "transactionList", TRANSACTION_LIST}), result -> {
                ResourceIterator msgIterator = result.columnAs("transactionId");
                if (!msgIterator.hasNext()) {
                    return false;
                }
                transactionId[0] = (String)msgIterator.next();
                Assert.assertNotNull((Object)transactionId[0]);
                TestUtil.testCall(db, "TERMINATE TRANSACTION $transactionId", MapUtil.map((Object[])new Object[]{"transactionId", transactionId[0]}), r1 -> Assert.assertEquals((Object)"Transaction terminated.", r1.get("message")));
                return true;
            }), value -> value, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
        }).start();
    }
}

