/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.Util;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.File;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.utility.DockerImageName;

public class S3Container
implements AutoCloseable {
    private static final String S3_BUCKET_NAME = "test-bucket";
    private final LocalStackContainer localstack = new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:1.2.0")).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.S3});
    private final AmazonS3 s3;

    public S3Container() {
        this.localstack.addExposedPorts(new int[]{4566});
        this.localstack.start();
        this.s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(this.getEndpointConfiguration())).withCredentials(this.getCredentialsProvider())).build();
        this.s3.createBucket(S3_BUCKET_NAME);
    }

    @Override
    public void close() {
        Util.close((AutoCloseable)this.localstack);
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration() {
        return new AwsClientBuilder.EndpointConfiguration(this.localstack.getEndpoint().toString(), this.localstack.getRegion());
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.localstack.getAccessKey(), this.localstack.getSecretKey()));
    }

    public String getUrl(String key) {
        return String.format("s3://%s.%s/%s/%s?accessKey=%s&secretKey=%s", this.getEndpointConfiguration().getSigningRegion(), this.getEndpointConfiguration().getServiceEndpoint().replace("http://", ""), S3_BUCKET_NAME, key, this.getCredentialsProvider().getCredentials().getAWSAccessKeyId(), this.getCredentialsProvider().getCredentials().getAWSSecretKey());
    }

    public String putFile(String fileName) {
        File file = new File(fileName);
        this.s3.putObject(S3_BUCKET_NAME, file.getName(), file);
        return this.getUrl(file.getName());
    }
}

