/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.s3.S3Aws;
import apoc.util.s3.S3Params;
import apoc.util.s3.S3ParamsExtractor;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class S3TestUtil {
    public static String readS3FileToString(String s3Url) throws AmazonClientException {
        try {
            S3Object s3object = S3TestUtil.getS3Object(s3Url);
            S3ObjectInputStream inputStream = s3object.getObjectContent();
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static S3Object getS3Object(String s3Url) throws MalformedURLException, AmazonClientException {
        S3Params s3Params = S3ParamsExtractor.extract((URL)new URL(s3Url));
        S3Aws s3Aws = new S3Aws(s3Params, s3Params.getRegion());
        AmazonS3 s3Client = s3Aws.getClient();
        return s3Client.getObject(s3Params.getBucket(), s3Params.getKey());
    }

    public static void assertStringFileEquals(String expected, String s3Url) {
        S3TestUtil.assertS3KeyEventually(() -> {
            String actual = S3TestUtil.readS3FileToString(s3Url);
            Assert.assertEquals((Object)expected, (Object)actual);
        });
    }

    public static void assertS3KeyEventually(Runnable runnable) {
        org.neo4j.test.assertion.Assert.assertEventually(() -> {
            try {
                runnable.run();
                return true;
            }
            catch (AmazonClientException e) {
                if (e.getMessage().contains("The specified key does not exist")) {
                    return false;
                }
                throw e;
            }
        }, v -> v, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }
}

