/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.Neo4jDatabaseManagementServiceBuilder;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ExternalResource;

public abstract class DbmsRule
extends ExternalResource
implements GraphDatabaseAPI {
    private Neo4jDatabaseManagementServiceBuilder databaseBuilder;
    private GraphDatabaseAPI database;
    private boolean startEagerly = true;
    private final Map<Setting<?>, Object> globalConfig = new HashMap();
    private DatabaseManagementService managementService;

    public DbmsRule startLazily() {
        this.startEagerly = false;
        return this;
    }

    public void executeTransactionally(String query) throws QueryExecutionException {
        this.getGraphDatabaseAPI().executeTransactionally(query);
    }

    public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.getGraphDatabaseAPI().executeTransactionally(query, parameters);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
        return (T)this.getGraphDatabaseAPI().executeTransactionally(query, parameters, resultTransformer);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
        return (T)this.getGraphDatabaseAPI().executeTransactionally(query, parameters, resultTransformer, timeout);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext, connectionInfo);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeout, TimeUnit unit) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext, connectionInfo, timeout, unit);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout, TimeUnit unit, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext, clientInfo, timeout, unit, terminationCallback, transactionExceptionMapper);
    }

    public Transaction beginTx() {
        return this.getGraphDatabaseAPI().beginTx();
    }

    public Transaction beginTx(long timeout, TimeUnit timeUnit) {
        return this.getGraphDatabaseAPI().beginTx(timeout, timeUnit);
    }

    @Override
    protected void before() {
        this.create();
        if (this.startEagerly) {
            this.ensureStarted();
        }
    }

    @Override
    protected void after() {
        this.shutdown();
    }

    private void create() {
        this.databaseBuilder = this.newFactory();
        this.databaseBuilder.setConfig(this.globalConfig);
    }

    protected abstract Neo4jDatabaseManagementServiceBuilder newFactory();

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        this.ensureStarted();
        return this.database;
    }

    public DatabaseManagementService getManagementService() {
        return this.managementService;
    }

    public synchronized void ensureStarted() {
        if (this.database == null) {
            this.managementService = this.databaseBuilder.build();
            this.database = (GraphDatabaseAPI)this.managementService.database("neo4j");
        }
    }

    public <T> DbmsRule withSetting(Setting<T> key, T value) {
        if (this.database != null) {
            throw new IllegalStateException("Wanted to set " + key + "=" + value + ", but database has already been started");
        }
        if (this.databaseBuilder != null) {
            this.databaseBuilder.setConfig(key, value);
        } else {
            this.globalConfig.put(key, value);
        }
        return this;
    }

    public void restartDatabase(Map<Setting<?>, Object> configChanges) {
        this.managementService.shutdown();
        this.database = null;
        this.databaseBuilder.setConfig(configChanges);
        this.getGraphDatabaseAPI();
    }

    public void shutdown() {
        try {
            if (this.managementService != null) {
                this.managementService.shutdown();
            }
        }
        finally {
            this.managementService = null;
            this.database = null;
        }
    }

    public NamedDatabaseId databaseId() {
        return this.database.databaseId();
    }

    public DbmsInfo dbmsInfo() {
        return this.database.dbmsInfo();
    }

    public TopologyGraphDbmsModel.HostedOnMode mode() {
        return this.database.mode();
    }

    public DependencyResolver getDependencyResolver() {
        return this.database.getDependencyResolver();
    }

    public DatabaseLayout databaseLayout() {
        return this.database.databaseLayout();
    }

    public boolean isAvailable(long timeout) {
        return this.database.isAvailable(timeout);
    }

    public boolean isAvailable() {
        return this.database.isAvailable();
    }

    public String databaseName() {
        return this.database.databaseName();
    }
}

