/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class ExternalResource
implements TestRule {
    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ExternalResource.this.before();
                Throwable failure = null;
                try {
                    base.evaluate();
                }
                catch (Throwable e) {
                    failure = e;
                }
                finally {
                    try {
                        ExternalResource.this.after();
                    }
                    catch (Throwable e) {
                        if (failure != null) {
                            failure.addSuppressed(e);
                        }
                        failure = e;
                    }
                }
                if (failure != null) {
                    throw failure;
                }
            }
        };
    }

    protected void before() {
    }

    protected void after() {
    }
}

