/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo.algorithms;

import java.util.Arrays;

public class Chunks {
    private int[] baseChunk;
    public static final int CHUNK_BITS = 16;
    private final int chunkSize;
    private final int chunkBits;
    private final int mask;
    int[][] chunks;
    int numChunks = 0;
    int maxIndex = 0;
    private int defaultValue = 0;

    public Chunks() {
        this(1, 16);
    }

    public Chunks(int capacity) {
        this((capacity >> 16) + 1, 16);
    }

    Chunks(int numChunks, int chunkBits) {
        this.chunkSize = 1 << chunkBits;
        this.chunkBits = chunkBits;
        this.mask = this.chunkSize - 1;
        this.chunks = new int[numChunks][this.chunkSize];
        this.numChunks = numChunks;
    }

    public Chunks withDefault(int defaultValue) {
        this.defaultValue = defaultValue;
        if (defaultValue != 0) {
            for (int[] chunk : this.chunks) {
                Arrays.fill(chunk, defaultValue);
            }
        }
        return this;
    }

    void set(int index, int value) {
        int chunk = this.assertSpace(index);
        this.chunks[chunk][index & this.mask] = value;
    }

    public void increment(int index) {
        int chunk = this.assertSpace(index);
        int[] nArray = this.chunks[chunk];
        int n = index & this.mask;
        nArray[n] = nArray[n] + 1;
    }

    private int assertSpace(int index) {
        int chunk = index >> this.chunkBits;
        if (index > this.maxIndex) {
            this.maxIndex = index;
            if (chunk >= this.numChunks) {
                this.growTo(chunk);
            }
        }
        if (this.chunks[chunk] == null) {
            this.growTo(chunk);
        }
        return chunk;
    }

    int get(int index) {
        if (index > this.maxIndex) {
            return this.defaultValue;
        }
        int chunk = index >> this.chunkBits;
        if (this.chunks[chunk] == null) {
            return this.defaultValue;
        }
        return this.chunks[chunk][index & this.mask];
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public int size() {
        return this.maxIndex + 1;
    }

    public int getFilledChunks() {
        return this.size() / this.chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    int[][] getChunks() {
        return this.chunks;
    }

    private void growTo(int chunk) {
        int newNumChunks = Math.max(chunk + 1, this.numChunks);
        if (newNumChunks != this.numChunks) {
            int[][] newChunks = new int[newNumChunks][];
            System.arraycopy(this.chunks, 0, newChunks, 0, this.numChunks);
            this.chunks = newChunks;
            this.numChunks = newNumChunks;
        }
        if (this.chunks[chunk] == null) {
            this.chunks[chunk] = this.newChunk();
        }
    }

    private int[] newChunk() {
        if (this.defaultValue == 0) {
            return new int[this.chunkSize];
        }
        if (this.baseChunk == null) {
            this.baseChunk = new int[this.chunkSize];
            Arrays.fill(this.baseChunk, this.defaultValue);
        }
        return (int[])this.baseChunk.clone();
    }

    public void sumUp() {
        int offset = 0;
        int tmp = 0;
        for (int i = 0; i < this.numChunks; ++i) {
            int[] chunk = this.chunks[i];
            if (chunk == null) {
                throw new IllegalStateException("Chunks are not continous, null fragement at offset " + i);
            }
            for (int j = 0; j < this.chunkSize; ++j) {
                tmp = chunk[j];
                chunk[j] = offset;
                offset += tmp;
            }
        }
    }

    public void add(Chunks c) {
        assert (c.chunkBits == this.chunkBits);
        assert (c.defaultValue == this.defaultValue);
        int[][] oChunks = c.chunks;
        if (c.numChunks > this.numChunks) {
            this.growTo(c.numChunks - 1);
        }
        for (int i = 0; i < oChunks.length; ++i) {
            int[] oChunk = oChunks[i];
            if (oChunk == null) continue;
            if (this.chunks[i] == null) {
                this.chunks[i] = (int[])oChunk.clone();
                continue;
            }
            int[] chunk = this.chunks[i];
            for (int j = 0; j < oChunk.length; ++j) {
                int n = j;
                chunk[n] = chunk[n] + oChunk[j];
            }
        }
        this.maxIndex = Math.max(this.maxIndex, c.maxIndex);
    }

    public Chunks clone() {
        Chunks result = new Chunks(0, this.chunkBits);
        int[][] newChunks = new int[this.numChunks][];
        for (int i = 0; i < this.numChunks; ++i) {
            if (this.chunks[i] == null) continue;
            newChunks[i] = (int[])this.chunks[i].clone();
        }
        result.defaultValue = this.defaultValue;
        result.chunks = newChunks;
        result.maxIndex = this.maxIndex;
        result.numChunks = this.numChunks;
        return result;
    }

    public int[] mergeAllChunks() {
        int[] merged = new int[this.chunkSize * this.numChunks];
        int filledChunks = Math.min(this.numChunks, this.getFilledChunks() + 1);
        for (int i = 0; i < filledChunks; ++i) {
            if (this.chunks[i] == null) continue;
            System.arraycopy(this.chunks[i], 0, merged, i * this.chunkSize, this.chunkSize);
        }
        if (this.defaultValue != 0) {
            Arrays.fill(merged, this.size(), merged.length, this.defaultValue);
        }
        return merged;
    }

    public int[] mergeChunks() {
        int filledChunks = this.getFilledChunks();
        int[] merged = new int[this.size()];
        for (int i = 0; i < filledChunks; ++i) {
            if (this.chunks[i] == null) continue;
            System.arraycopy(this.chunks[i], 0, merged, i * this.chunkSize, this.chunkSize);
        }
        int remainder = this.size() % this.chunkSize;
        if (remainder != 0 && this.chunks[filledChunks] != null) {
            System.arraycopy(this.chunks[filledChunks], 0, merged, filledChunks * this.chunkSize, remainder);
        }
        return merged;
    }

    public void clear() {
        this.numChunks = 0;
        this.maxIndex = -1;
        this.chunks = new int[0][];
    }

    public int consume(IndexValueConsumer consumer) {
        int j;
        int[] chunk;
        int offset;
        int filledChunks = this.getFilledChunks();
        for (int i = 0; i < filledChunks; ++i) {
            offset = i * this.chunkSize;
            chunk = this.chunks[i];
            if (chunk == null) continue;
            for (j = 0; j < this.chunkSize; ++j) {
                consumer.accept(offset + j, chunk[i]);
            }
        }
        int remainder = this.size() % this.chunkSize;
        if (remainder != 0) {
            offset = filledChunks * this.chunkSize;
            chunk = this.chunks[filledChunks];
            for (j = 0; j < remainder; ++j) {
                consumer.accept(offset + j, chunk[j]);
            }
        }
        return this.size();
    }

    static interface IndexValueConsumer {
        public void accept(int var1, int var2);
    }
}

