/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.ApocConfiguration;
import apoc.couchbase.CouchbaseConnection;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.auth.PasswordAuthenticator;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.parboiled.common.StringUtils;

public class CouchbaseManager {
    public static final DefaultCouchbaseEnvironment DEFAULT_COUCHBASE_ENVIRONMENT = DefaultCouchbaseEnvironment.create();
    protected static final String COUCHBASE_CONFIG_KEY = "couchbase.";
    protected static final String USERNAME_CONFIG_KEY = "username";
    protected static final String PASSWORD_CONFIG_KEY = "password";
    protected static final String URI_CONFIG_KEY = "uri";

    protected CouchbaseManager() {
    }

    @Deprecated
    public static CouchbaseConnection getConnection(List<String> nodes, String bucketName) {
        if (nodes == null) {
            nodes = Arrays.asList("127.0.0.1");
        }
        return new CouchbaseConnection((Cluster)CouchbaseCluster.create((CouchbaseEnvironment)DEFAULT_COUCHBASE_ENVIRONMENT, nodes), bucketName);
    }

    protected static URI checkAndGetURI(String hostOrKey) {
        URI uri = URI.create(hostOrKey);
        if (!StringUtils.isEmpty((String)uri.getScheme())) {
            String userInfo = uri.getUserInfo();
            if (StringUtils.isEmpty((String)userInfo)) {
                throw new RuntimeException("URI must include credentials otherwise use apoc.couchbase.<key>.* configuration");
            }
            String[] infoTokens = userInfo.split(":");
            if (infoTokens.length != 2) {
                throw new RuntimeException("Credentials must be defined according URI specifications");
            }
            return uri;
        }
        return null;
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromConfigurationKey(String configurationKey) {
        Object password;
        Map<String, Object> couchbaseConfig = ApocConfiguration.get(COUCHBASE_CONFIG_KEY + configurationKey);
        if (couchbaseConfig.isEmpty()) {
            throw new RuntimeException("Please check neo4j.conf file 'apoc.couchbase." + configurationKey + "' is missing");
        }
        Object username = couchbaseConfig.get(USERNAME_CONFIG_KEY);
        if (username == null || (password = couchbaseConfig.get(PASSWORD_CONFIG_KEY)) == null) {
            throw new RuntimeException("Please check you 'apoc.couchbase." + configurationKey + "' configuration, username and password are missing");
        }
        Object url = couchbaseConfig.get(URI_CONFIG_KEY);
        if (url == null) {
            throw new RuntimeException("Please check you 'apoc.couchbase." + configurationKey + "' configuration, url is missing");
        }
        return Pair.of((Object)new PasswordAuthenticator(username.toString(), password.toString()), Arrays.asList(url.toString().split(",")));
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromHost(URI host) {
        List<Object> nodes = Collections.emptyList();
        try {
            nodes = Arrays.asList(new URI(host.getScheme(), null, host.getHost(), host.getPort(), null, null, null).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String[] credentials = host.getUserInfo().split(":");
        return Pair.of((Object)new PasswordAuthenticator(credentials[0], credentials[1]), nodes);
    }

    protected static Pair<PasswordAuthenticator, List<String>> getConnectionObjectsFromHostOrKey(String hostOrKey) {
        URI singleHostURI = CouchbaseManager.checkAndGetURI(hostOrKey);
        if (singleHostURI == null || singleHostURI.getScheme() == null) {
            return CouchbaseManager.getConnectionObjectsFromConfigurationKey(hostOrKey);
        }
        return CouchbaseManager.getConnectionObjectsFromHost(singleHostURI);
    }

    public static CouchbaseConnection getConnection(String hostOrKey, String bucketName) {
        Pair<PasswordAuthenticator, List<String>> connectionObjects = CouchbaseManager.getConnectionObjectsFromHostOrKey(hostOrKey);
        String[] bucketCredentials = bucketName.split(":");
        return new CouchbaseConnection((List)connectionObjects.other(), (PasswordAuthenticator)connectionObjects.first(), bucketCredentials[0], bucketCredentials.length == 2 ? bucketCredentials[1] : null);
    }
}

