/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.util.JsonUtil;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.collection.PrefetchingRawIterator;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.MapValue;

public class CypherProcedures {
    private static final String PREFIX = "custom";
    public static final String FUNCTIONS = "functions";
    public static final String PROCEDURES = "procedures";
    @org.neo4j.procedure.Context
    public GraphDatabaseAPI api;
    @org.neo4j.procedure.Context
    public Log log;

    @Procedure(value="apoc.custom.asProcedure", mode=Mode.WRITE)
    public void asProcedure(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="outputs", defaultValue="null") List<List<String>> outputs, @Name(value="inputs", defaultValue="null") List<List<String>> inputs) throws ProcedureException {
        CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
        if (!registry.registerProcedure(name, statement, mode, outputs, inputs)) {
            throw new IllegalStateException("Error registering procedure " + name + ", see log.");
        }
        CustomProcedureStorage.storeProcedure(name, statement, mode, outputs, inputs);
    }

    @Procedure(value="apoc.custom.asFunction", mode=Mode.WRITE)
    public void asFunction(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="outputs", defaultValue="") String output, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="forceSingle", defaultValue="false") boolean forceSingle) throws ProcedureException {
        CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
        if (!registry.registerFunction(name, statement, output, inputs, forceSingle)) {
            throw new IllegalStateException("Error registering function " + name + ", see log.");
        }
        CustomProcedureStorage.storeFunction(name, statement, output, inputs, forceSingle);
    }

    public static class CustomProcedureStorage
    implements AvailabilityGuard.AvailabilityListener {
        public static final String APOC_CUSTOM = "apoc.custom";
        private static GraphProperties properties;
        private final GraphDatabaseAPI api;
        private final Log log;

        public CustomProcedureStorage(GraphDatabaseAPI api, Log log) {
            this.api = api;
            this.log = log;
        }

        public void available() {
            properties = ((EmbeddedProxySPI)this.api.getDependencyResolver().resolveDependency(EmbeddedProxySPI.class)).newGraphPropertiesProxy();
            this.restoreProcedures();
        }

        private void restoreProcedures() {
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                CustomStatementRegistry registry = new CustomStatementRegistry(this.api, this.log);
                Map<String, Map<String, Map<String, Object>>> stored = CustomProcedureStorage.readData();
                stored.get(CypherProcedures.FUNCTIONS).forEach((name, data) -> registry.registerFunction((String)name, (String)data.get("statement"), (String)data.get("output"), (List)data.get("inputs"), (Boolean)data.get("forceSingle")));
                stored.get(CypherProcedures.PROCEDURES).forEach((name, data) -> registry.registerProcedure((String)name, (String)data.get("statement"), (String)data.get("mode"), (List)data.get("outputs"), (List)data.get("inputs")));
            }
        }

        public void unavailable() {
            properties = null;
        }

        public static Map<String, Object> storeProcedure(String name, String statement, String mode, List<List<String>> outputs, List<List<String>> inputs) {
            Map<String, Object> data = Util.map("statement", statement, "mode", mode, "inputs", inputs, "outputs", outputs);
            return CustomProcedureStorage.updateCustomData(name, CypherProcedures.PROCEDURES, data);
        }

        public static Map<String, Object> storeFunction(String name, String statement, String output, List<List<String>> inputs, boolean forceSingle) {
            Map<String, Object> data = Util.map("statement", statement, "forceSingle", forceSingle, "inputs", inputs, "output", output);
            return CustomProcedureStorage.updateCustomData(name, CypherProcedures.FUNCTIONS, data);
        }

        public static synchronized Map<String, Object> remove(String name, String type) {
            return CustomProcedureStorage.updateCustomData(name, type, null);
        }

        private static synchronized Map<String, Object> updateCustomData(String name, String type, Map<String, Object> value) {
            if (name == null || type == null) {
                return null;
            }
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                Map<String, Object> previous;
                Map<String, Map<String, Map<String, Object>>> data = CustomProcedureStorage.readData();
                Map<String, Map<String, Object>> procData = data.get(type);
                Map<String, Object> map = previous = value == null ? procData.remove(name) : procData.put(name, value);
                if (value != null || previous != null) {
                    properties.setProperty(APOC_CUSTOM, (Object)Util.toJson(data));
                }
                tx.success();
                Map<String, Object> map2 = previous;
                return map2;
            }
        }

        private static Map<String, Map<String, Map<String, Object>>> readData() {
            String procedurePropertyData = (String)properties.getProperty(APOC_CUSTOM, (Object)"{\"functions\":{},\"procedures\":{}}");
            return Util.fromJson(procedurePropertyData, Map.class);
        }

        public static Map<String, Map<String, Map<String, Object>>> list() {
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                Map<String, Map<String, Map<String, Object>>> map = CustomProcedureStorage.readData();
                return map;
            }
        }
    }

    static class CustomStatementRegistry {
        GraphDatabaseAPI api;
        Procedures procedures;
        private final Log log;

        public CustomStatementRegistry(GraphDatabaseAPI api, Log log) {
            this.api = api;
            this.procedures = (Procedures)api.getDependencyResolver().resolveDependency(Procedures.class);
            this.log = log;
        }

        public boolean registerProcedure(@Name(value="name") String name, final @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, final @Name(value="outputs", defaultValue="null") List<List<String>> outputs, final @Name(value="inputs", defaultValue="null") List<List<String>> inputs) {
            try {
                Procedures procedures = (Procedures)this.api.getDependencyResolver().resolveDependency(Procedures.class);
                ProcedureSignature signature = new ProcedureSignature(this.qualifiedName(name), this.inputSignatures(inputs), this.outputSignatures(outputs), Mode.valueOf((String)mode.toUpperCase()), null, new String[0], null, null, false, true);
                procedures.register((CallableProcedure)new CallableProcedure.BasicProcedure(signature){

                    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
                        Map<String, Object> params = this.params(input, inputs);
                        final Result result = api.execute(statement, params);
                        resourceTracker.registerCloseableResource((AutoCloseable)result);
                        final String[] names = outputs == null ? null : (String[])outputs.stream().map(pair -> (String)pair.get(0)).toArray(String[]::new);
                        return new PrefetchingRawIterator<Object[], ProcedureException>(){

                            protected Object[] fetchNextOrNull() {
                                if (!result.hasNext()) {
                                    return null;
                                }
                                Map row = result.next();
                                return this.toResult(row, names);
                            }
                        };
                    }
                }, true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Could not register procedure: " + name + " with " + statement + "\n accepting" + inputs + " resulting in " + outputs + " mode " + mode, (Throwable)e);
                return false;
            }
        }

        public boolean registerFunction(String name, final String statement, final String output, final List<List<String>> inputs, final boolean forceSingle) {
            try {
                final Neo4jTypes.AnyType outType = this.typeof(output.isEmpty() ? "LIST OF MAP" : output);
                UserFunctionSignature signature = new UserFunctionSignature(this.qualifiedName(name), this.inputSignatures(inputs), outType, null, new String[0], null, false);
                final DefaultValueMapper defaultValueMapper = new DefaultValueMapper((EmbeddedProxySPI)this.api.getDependencyResolver().resolveDependency(GraphDatabaseFacade.class));
                this.procedures.register((CallableUserFunction)new CallableUserFunction.BasicUserFunction(signature){

                    public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
                        Map<String, Object> params = this.functionParams(input, inputs, defaultValueMapper);
                        Throwable throwable = null;
                        try (Result result = api.execute(statement, params);){
                            if (!result.hasNext()) {
                                AnyValue anyValue = null;
                                return anyValue;
                            }
                            if (output.isEmpty()) {
                                AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                                return anyValue;
                            }
                            List cols = result.columns();
                            if (cols.isEmpty()) {
                                AnyValue anyValue = null;
                                return anyValue;
                            }
                            if (!forceSingle && outType instanceof Neo4jTypes.ListType) {
                                Neo4jTypes.ListType listType = (Neo4jTypes.ListType)outType;
                                Neo4jTypes.AnyType innerType = listType.innerType();
                                if (innerType instanceof Neo4jTypes.MapType) {
                                    AnyValue anyValue = ValueUtils.of(result.stream().collect(Collectors.toList()));
                                    return anyValue;
                                }
                                if (cols.size() == 1) {
                                    AnyValue anyValue = ValueUtils.of(result.stream().map(row -> row.get(cols.get(0))).collect(Collectors.toList()));
                                    return anyValue;
                                }
                            } else {
                                Map row2 = result.next();
                                if (outType instanceof Neo4jTypes.MapType) {
                                    AnyValue anyValue = ValueUtils.of((Object)row2);
                                    return anyValue;
                                }
                                if (cols.size() == 1) {
                                    AnyValue anyValue = ValueUtils.of(row2.get(cols.get(0)));
                                    return anyValue;
                                }
                            }
                            try {
                                throw new IllegalStateException("Result mismatch " + cols + " output type is " + output);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                    }
                }, true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Could not register function: " + name + " with " + statement + "\n accepting" + inputs + " resulting in " + output + " single result " + forceSingle, (Throwable)e);
                return false;
            }
        }

        public QualifiedName qualifiedName(@Name(value="name") String name) {
            String[] names = name.split("\\.");
            ArrayList<String> namespace = new ArrayList<String>(names.length);
            namespace.add(CypherProcedures.PREFIX);
            namespace.addAll(Arrays.asList(names));
            return new QualifiedName(namespace.subList(0, namespace.size() - 1), names[names.length - 1]);
        }

        public List<FieldSignature> inputSignatures(@Name(value="inputs", defaultValue="null") List<List<String>> inputs) {
            List<FieldSignature> inputSignature = inputs == null ? Collections.singletonList(FieldSignature.inputField((String)"params", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.ntMap(Collections.emptyMap()))) : inputs.stream().map(pair -> {
                DefaultParameterValue defaultValue = this.defaultValue((String)pair.get(1), pair.size() > 2 ? (String)pair.get(2) : null);
                return defaultValue == null ? FieldSignature.inputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1))) : FieldSignature.inputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1)), (DefaultParameterValue)defaultValue);
            }).collect(Collectors.toList());
            return inputSignature;
        }

        public List<FieldSignature> outputSignatures(@Name(value="outputs", defaultValue="null") List<List<String>> outputs) {
            return outputs == null ? Collections.singletonList(FieldSignature.inputField((String)"row", (Neo4jTypes.AnyType)Neo4jTypes.NTMap)) : outputs.stream().map(pair -> FieldSignature.outputField((String)((String)pair.get(0)), (Neo4jTypes.AnyType)this.typeof((String)pair.get(1)))).collect(Collectors.toList());
        }

        private Neo4jTypes.AnyType typeof(String typeName) {
            if ((typeName = typeName.toUpperCase()).startsWith("LIST OF ")) {
                return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.typeof(typeName.substring(8)));
            }
            if (typeName.startsWith("LIST ")) {
                return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.typeof(typeName.substring(5)));
            }
            switch (typeName) {
                case "ANY": {
                    return Neo4jTypes.NTAny;
                }
                case "MAP": {
                    return Neo4jTypes.NTMap;
                }
                case "NODE": {
                    return Neo4jTypes.NTNode;
                }
                case "REL": {
                    return Neo4jTypes.NTRelationship;
                }
                case "RELATIONSHIP": {
                    return Neo4jTypes.NTRelationship;
                }
                case "EDGE": {
                    return Neo4jTypes.NTRelationship;
                }
                case "PATH": {
                    return Neo4jTypes.NTPath;
                }
                case "NUMBER": {
                    return Neo4jTypes.NTNumber;
                }
                case "LONG": {
                    return Neo4jTypes.NTInteger;
                }
                case "INT": {
                    return Neo4jTypes.NTInteger;
                }
                case "INTEGER": {
                    return Neo4jTypes.NTInteger;
                }
                case "FLOAT": {
                    return Neo4jTypes.NTFloat;
                }
                case "DOUBLE": {
                    return Neo4jTypes.NTFloat;
                }
                case "BOOL": {
                    return Neo4jTypes.NTBoolean;
                }
                case "BOOLEAN": {
                    return Neo4jTypes.NTBoolean;
                }
                case "DATE": {
                    return Neo4jTypes.NTDate;
                }
                case "TIME": {
                    return Neo4jTypes.NTTime;
                }
                case "LOCALTIME": {
                    return Neo4jTypes.NTLocalTime;
                }
                case "DATETIME": {
                    return Neo4jTypes.NTDateTime;
                }
                case "LOCALDATETIME": {
                    return Neo4jTypes.NTLocalDateTime;
                }
                case "DURATION": {
                    return Neo4jTypes.NTDuration;
                }
                case "POINT": {
                    return Neo4jTypes.NTPoint;
                }
                case "GEO": {
                    return Neo4jTypes.NTGeometry;
                }
                case "GEOMETRY": {
                    return Neo4jTypes.NTGeometry;
                }
                case "STRING": {
                    return Neo4jTypes.NTString;
                }
                case "TEXT": {
                    return Neo4jTypes.NTString;
                }
            }
            return Neo4jTypes.NTString;
        }

        private DefaultParameterValue defaultValue(String typeName, String stringValue) {
            if (stringValue == null) {
                return null;
            }
            Object value = JsonUtil.parse(stringValue, null, Object.class);
            if (value == null) {
                return null;
            }
            if ((typeName = typeName.toUpperCase()).startsWith("LIST ")) {
                return DefaultParameterValue.ntList((List)((List)value), (Neo4jTypes.AnyType)this.typeof(typeName.substring(5)));
            }
            switch (typeName) {
                case "MAP": {
                    return DefaultParameterValue.ntMap((Map)((Map)value));
                }
                case "NODE": 
                case "REL": 
                case "RELATIONSHIP": 
                case "EDGE": 
                case "PATH": {
                    return null;
                }
                case "NUMBER": {
                    return value instanceof Float || value instanceof Double ? DefaultParameterValue.ntFloat((double)((Number)value).doubleValue()) : DefaultParameterValue.ntInteger((long)((Number)value).longValue());
                }
                case "LONG": 
                case "INT": 
                case "INTEGER": {
                    return DefaultParameterValue.ntInteger((long)((Number)value).longValue());
                }
                case "FLOAT": 
                case "DOUBLE": {
                    return DefaultParameterValue.ntFloat((double)((Number)value).doubleValue());
                }
                case "BOOL": 
                case "BOOLEAN": {
                    return DefaultParameterValue.ntBoolean((boolean)((Boolean)value));
                }
                case "DATE": 
                case "TIME": 
                case "LOCALTIME": 
                case "DATETIME": 
                case "LOCALDATETIME": 
                case "DURATION": 
                case "POINT": 
                case "GEO": 
                case "GEOMETRY": {
                    return null;
                }
                case "STRING": 
                case "TEXT": {
                    return DefaultParameterValue.ntString((String)value.toString());
                }
            }
            return null;
        }

        private Object[] toResult(Map<String, Object> row, String[] names) {
            if (names == null) {
                return new Object[]{row};
            }
            Object[] result = new Object[names.length];
            for (int i = 0; i < names.length; ++i) {
                result[i] = row.get(names[i]);
            }
            return result;
        }

        public Map<String, Object> params(Object[] input, @Name(value="inputs", defaultValue="null") List<List<String>> inputs) {
            if (inputs == null) {
                return (Map)input[0];
            }
            HashMap<String, Object> params = new HashMap<String, Object>(input.length);
            for (int i = 0; i < input.length; ++i) {
                params.put(inputs.get(i).get(0), input[i]);
            }
            return params;
        }

        public Map<String, Object> functionParams(Object[] input, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, DefaultValueMapper mapper) {
            if (inputs == null) {
                return (Map)((MapValue)input[0]).map((ValueMapper)mapper);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(input.length);
            for (int i = 0; i < input.length; ++i) {
                params.put(inputs.get(i).get(0), ((AnyValue)input[i]).map((ValueMapper)mapper));
            }
            return params;
        }
    }
}

