/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Pools;
import apoc.result.MapResult;
import apoc.util.FileUtils;
import apoc.util.MapUtil;
import apoc.util.QueueBasedSpliterator;
import apoc.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Cypher {
    public static final String COMPILED_PREFIX = "CYPHER runtime=interpreted";
    public static final ExecutorService POOL = Pools.DEFAULT;
    public static final int PARTITIONS = 100 * Runtime.getRuntime().availableProcessors();
    public static final int MAX_BATCH = 10000;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public TerminationGuard terminationGuard;
    private static final Pattern shellControl = Pattern.compile("^:?\\b(begin|commit|rollback)\\b", 2);

    @Procedure
    @Description(value="apoc.cypher.run(fragment, params) yield value - executes reading fragment with the given parameters")
    public Stream<MapResult> run(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        return this.db.execute(Cypher.withParamMapping(statement, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.runFile(file or url,[{statistics:true,timeout:10,parameters:{}}]) - runs each kernelTransaction in the file, all semicolon separated - currently no schema operations")
    public Stream<RowResult> runFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.runFiles([files or urls],[{statistics:true,timeout:10,parameters:{}}])) - runs each kernelTransaction in the files, all semicolon separated")
    public Stream<RowResult> runFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean addStatistics = Util.toBoolean(config.getOrDefault("statistics", true));
        int timeout = Util.toInteger(config.getOrDefault("timeout", 10));
        ArrayList result = new ArrayList();
        Map<String, Object> parameters = config.getOrDefault("parameters", Collections.emptyMap());
        for (String f : fileNames) {
            List rowResults = this.runManyStatements(this.readerForFile(f), parameters, false, addStatistics, timeout).collect(Collectors.toList());
            result.addAll(rowResults);
        }
        return result.stream();
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.cypher.runSchemaFile(file or url,[{statistics:true,timeout:10}]) - allows only schema operations, runs each schema kernelTransaction in the file, all semicolon separated")
    public Stream<RowResult> runSchemaFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runSchemaFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.cypher.runSchemaFiles([files or urls],{statistics:true,timeout:10}) - allows only schema operations, runs each schema kernelTransaction in the files, all semicolon separated")
    public Stream<RowResult> runSchemaFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean addStatistics = Util.toBoolean(config.getOrDefault("statistics", true));
        int timeout = Util.toInteger(config.getOrDefault("timeout", 10));
        ArrayList result = new ArrayList();
        for (String f : fileNames) {
            List rowResults = this.runManyStatements(this.readerForFile(f), Collections.emptyMap(), true, addStatistics, timeout).collect(Collectors.toList());
            result.addAll(rowResults);
        }
        return result.stream();
    }

    private Stream<RowResult> runManyStatements(Reader reader, Map<String, Object> params, boolean schemaOperation, boolean addStatistics, int timeout) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        Util.inThread(() -> {
            if (schemaOperation) {
                this.runSchemaStatementsInTx(reader, queue, params, addStatistics);
            } else {
                this.runDataStatementsInTx(reader, queue, params, addStatistics);
            }
            queue.put(RowResult.TOMBSTONE);
            return null;
        });
        return StreamSupport.stream(new QueueBasedSpliterator<RowResult>(queue, RowResult.TOMBSTONE, this.terminationGuard, timeout), false);
    }

    private void runDataStatementsInTx(Reader reader, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics) {
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter(";\r?\n");
        while (scanner.hasNext()) {
            String stmt = this.removeShellControlCommands(scanner.next());
            if (stmt.trim().isEmpty() || this.isSchemaOperation(stmt)) continue;
            if (this.isPeriodicOperation(stmt)) {
                Util.inThread(() -> this.executeStatement(queue, stmt, params, addStatistics));
                continue;
            }
            Util.inTx(this.db, () -> this.executeStatement(queue, stmt, params, addStatistics));
        }
    }

    private void runSchemaStatementsInTx(Reader reader, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics) {
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter(";\r?\n");
        while (scanner.hasNext()) {
            String stmt = this.removeShellControlCommands(scanner.next());
            if (stmt.trim().isEmpty() || !this.isSchemaOperation(stmt)) continue;
            Util.inTx(this.db, () -> this.executeStatement(queue, stmt, params, addStatistics));
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.runMany('cypher;\\nstatements;',{params},[{statistics:true,timeout:10}]) - runs each semicolon separated kernelTransaction and returns summary - currently no schema operations")
    public Stream<RowResult> runMany(@Name(value="cypher") String cypher, @Name(value="params") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean addStatistics = Util.toBoolean(config.getOrDefault("statistics", true));
        int timeout = Util.toInteger(config.getOrDefault("timeout", 1));
        StringReader stringReader = new StringReader(cypher);
        return this.runManyStatements(stringReader, params, false, addStatistics, timeout);
    }

    private Object executeStatement(BlockingQueue<RowResult> queue, String stmt, Map<String, Object> params, boolean addStatistics) throws InterruptedException {
        try (Result result = this.db.execute(stmt, params);){
            long time = System.currentTimeMillis();
            int row = 0;
            while (result.hasNext()) {
                this.terminationGuard.check();
                queue.put(new RowResult(row++, result.next()));
            }
            if (addStatistics) {
                queue.offer(new RowResult(-1L, this.toMap(result.getQueryStatistics(), System.currentTimeMillis() - time, row)), 100L, TimeUnit.MILLISECONDS);
            }
            Integer n = row;
            return n;
        }
    }

    private String removeShellControlCommands(String stmt) {
        Matcher matcher = shellControl.matcher(stmt.trim());
        if (matcher.find()) {
            stmt = matcher.replaceAll("");
        }
        return stmt;
    }

    private boolean isSchemaOperation(String stmt) {
        return stmt.matches("(?is).*(create|drop)\\s+(index|constraint).*");
    }

    private boolean isPeriodicOperation(String stmt) {
        return stmt.matches("(?is).*using\\s+periodic.*");
    }

    private Map<String, Object> toMap(QueryStatistics stats, long time, long rows) {
        return MapUtil.map("rows", rows, "time", time, "nodesCreated", stats.getNodesCreated(), "nodesDeleted", stats.getNodesDeleted(), "labelsAdded", stats.getLabelsAdded(), "labelsRemoved", stats.getLabelsRemoved(), "relationshipsCreated", stats.getRelationshipsCreated(), "relationshipsDeleted", stats.getRelationshipsDeleted(), "propertiesSet", stats.getPropertiesSet(), "constraintsAdded", stats.getConstraintsAdded(), "constraintsRemoved", stats.getConstraintsRemoved(), "indexesAdded", stats.getIndexesAdded(), "indexesRemoved", stats.getIndexesRemoved());
    }

    private Reader readerForFile(@Name(value="file") String fileName) {
        try {
            return FileUtils.readerFor(fileName);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error accessing file " + fileName, ioe);
        }
    }

    public static String withParamMapping(String fragment, Collection<String> keys) {
        if (keys.isEmpty()) {
            return fragment;
        }
        String declaration = " WITH " + String.join((CharSequence)", ", keys.stream().map(s -> String.format(" {`%s`} as `%s` ", s, s)).collect(Collectors.toList()));
        return declaration + fragment;
    }

    public static String compiled(String fragment) {
        return fragment.substring(0, 6).equalsIgnoreCase("cypher") ? fragment : COMPILED_PREFIX + fragment;
    }

    @Procedure
    public Stream<MapResult> parallel(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="parallelizeOn") String key) {
        if (params == null) {
            return this.run(fragment, params);
        }
        if (key == null || !params.containsKey(key)) {
            throw new RuntimeException("Can't parallelize on key " + key + " available keys " + params.keySet());
        }
        Object value = params.get(key);
        if (!(value instanceof Collection)) {
            throw new RuntimeException("Can't parallelize a non collection " + key + " : " + value);
        }
        String statement = Cypher.withParamMapping(fragment, params.keySet());
        Collection coll = (Collection)value;
        return coll.parallelStream().flatMap(v -> {
            this.terminationGuard.check();
            HashMap<String, Object> parallelParams = new HashMap<String, Object>(params);
            parallelParams.replace(key, v);
            return this.db.execute(statement, parallelParams).stream().map(MapResult::new);
        });
    }

    @Procedure
    @Description(value="apoc.cypher.mapParallel(fragment, params, list-to-parallelize) yield value - executes fragment in parallel batches with the list segments being assigned to _")
    public Stream<MapResult> mapParallel(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="list") List<Object> data) {
        String statement = Cypher.withParamsAndIterator(fragment, params.keySet(), "_");
        this.db.execute("EXPLAIN " + statement).close();
        return Util.partitionSubList(data, PARTITIONS, null).flatMap(partition -> ((ArrayList)Iterators.addToCollection((Iterator)this.db.execute(statement, this.parallelParams(params, "_", (List<Object>)partition)), new ArrayList(partition.size()))).stream()).map(MapResult::new);
    }

    @Procedure
    @Description(value="apoc.cypher.mapParallel2(fragment, params, list-to-parallelize) yield value - executes fragment in parallel batches with the list segments being assigned to _")
    public Stream<MapResult> mapParallel2(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="list") List<Object> data, @Name(value="partitions") long partitions) {
        String statement = Cypher.withParamsAndIterator(fragment, params.keySet(), "_");
        this.db.execute("EXPLAIN " + statement).close();
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100000);
        Stream<List<Object>> parallelPartitions = Util.partitionSubList(data, (int)(partitions <= 0L ? (long)PARTITIONS : partitions), null);
        Util.inFuture(() -> {
            long total = parallelPartitions.map(partition -> {
                try {
                    return this.executeStatement(queue, statement, this.parallelParams(params, "_", (List<Object>)partition), false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).count();
            queue.put(RowResult.TOMBSTONE);
            return total;
        });
        return StreamSupport.stream(new QueueBasedSpliterator<RowResult>(queue, RowResult.TOMBSTONE, this.terminationGuard), true).map(rowResult -> new MapResult(rowResult.result));
    }

    public Stream<List<Object>> partitionColl(@Name(value="list") Collection<Object> list, int partitions) {
        int total = list.size();
        int batchSize = Math.max(total / partitions, 1);
        ArrayList result = new ArrayList(PARTITIONS);
        ArrayList<Object> partition = new ArrayList<Object>(batchSize);
        for (Object o : list) {
            partition.add(o);
            if (partition.size() < batchSize) continue;
            result.add(partition);
            partition = new ArrayList(batchSize);
        }
        if (!partition.isEmpty()) {
            result.add(partition);
        }
        return result.stream();
    }

    public Map<String, Object> parallelParams(@Name(value="params") Map<String, Object> params, String key, List<Object> partition) {
        if (params.isEmpty()) {
            return Collections.singletonMap(key, partition);
        }
        HashMap<String, Object> parallelParams = new HashMap<String, Object>(params);
        parallelParams.put(key, partition);
        return parallelParams;
    }

    @Procedure
    public Stream<MapResult> parallel2(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="parallelizeOn") String key) {
        if (params == null) {
            return this.run(fragment, params);
        }
        if (key == null || !params.containsKey(key)) {
            throw new RuntimeException("Can't parallelize on key " + key + " available keys " + params.keySet());
        }
        Object value = params.get(key);
        if (!(value instanceof Collection)) {
            throw new RuntimeException("Can't parallelize a non collection " + key + " : " + value);
        }
        String statement = Cypher.withParamsAndIterator(fragment, params.keySet(), key);
        this.db.execute("EXPLAIN " + statement).close();
        Collection coll = (Collection)value;
        int total = coll.size();
        int partitions = PARTITIONS;
        int batchSize = Math.max(total / partitions, 1);
        if (batchSize > 10000) {
            batchSize = 10000;
            partitions = total / batchSize + 1;
        }
        ArrayList<Future<List<Map<String, Object>>>> futures = new ArrayList<Future<List<Map<String, Object>>>>(partitions);
        ArrayList<Object> partition = new ArrayList<Object>(batchSize);
        for (Object o : coll) {
            partition.add(o);
            if (partition.size() != batchSize) continue;
            this.terminationGuard.check();
            futures.add(this.submit(this.db, statement, params, key, partition));
            partition = new ArrayList(batchSize);
        }
        if (!partition.isEmpty()) {
            futures.add(this.submit(this.db, statement, params, key, partition));
        }
        return futures.stream().flatMap(f -> {
            try {
                return ((List)f.get()).stream().map(MapResult::new);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error executing in parallel " + statement, e);
            }
        });
    }

    public static String withParamsAndIterator(String fragment, Collection<String> params, String iterator) {
        boolean noIterator;
        boolean bl = noIterator = iterator == null || iterator.isEmpty();
        if (params.isEmpty() && noIterator) {
            return fragment;
        }
        String with = Util.withMapping(params.stream().filter(c -> noIterator || !c.equals(iterator)), c -> Util.param(c) + " AS " + Util.quote(c));
        if (noIterator) {
            return with + fragment;
        }
        return with + " UNWIND " + Util.param(iterator) + " AS " + Util.quote(iterator) + ' ' + fragment;
    }

    private Future<List<Map<String, Object>>> submit(GraphDatabaseService db, String statement, Map<String, Object> params, String key, List<Object> partition) {
        return POOL.submit(() -> (ArrayList)Iterators.addToCollection((Iterator)db.execute(statement, this.parallelParams(params, key, partition)), new ArrayList(partition.size())));
    }

    private static Collection asCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Iterable) {
            return Iterables.asCollection((Iterable)((Iterable)value));
        }
        if (value instanceof Iterator) {
            return Iterators.asCollection((Iterator)((Iterator)value));
        }
        return Collections.singleton(value);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.doIt(fragment, params) yield value - executes writing fragment with the given parameters")
    public Stream<MapResult> doIt(@Name(value="cypher") String statement, @Name(value="params") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        return this.db.execute(Cypher.withParamMapping(statement, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(value="apoc.when")
    @Description(value="apoc.when(condition, ifQuery, elseQuery:'', params:{}) yield value - based on the conditional, executes read-only ifQuery or elseQuery with the given parameters")
    public Stream<MapResult> when(@Name(value="condition") boolean condition, @Name(value="ifQuery") String ifQuery, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="") Map<String, Object> params) {
        String targetQuery;
        if (params == null) {
            params = Collections.emptyMap();
        }
        String string = targetQuery = condition ? ifQuery : elseQuery;
        if (targetQuery.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        return this.db.execute(Cypher.withParamMapping(targetQuery, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(value="apoc.do.when", mode=Mode.WRITE)
    @Description(value="apoc.do.when(condition, ifQuery, elseQuery:'', params:{}) yield value - based on the conditional, executes writing ifQuery or elseQuery with the given parameters")
    public Stream<MapResult> doWhen(@Name(value="condition") boolean condition, @Name(value="ifQuery") String ifQuery, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="") Map<String, Object> params) {
        return this.when(condition, ifQuery, elseQuery, params);
    }

    @Procedure(value="apoc.case")
    @Description(value="apoc.case([condition, query, condition, query, ...], elseQuery:'', params:{}) yield value - given a list of conditional / read-only query pairs, executes the query associated with the first conditional evaluating to true (or the else query if none are true) with the given parameters")
    public Stream<MapResult> whenCase(@Name(value="conditionals") List<Object> conditionals, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (conditionals.size() % 2 != 0) {
            throw new IllegalArgumentException("Conditionals must be an even-sized collection of boolean, query entries");
        }
        Iterator<Object> caseItr = conditionals.iterator();
        while (caseItr.hasNext()) {
            boolean condition = (Boolean)caseItr.next();
            String ifQuery = (String)caseItr.next();
            if (!condition) continue;
            return this.db.execute(Cypher.withParamMapping(ifQuery, params.keySet()), params).stream().map(MapResult::new);
        }
        if (elseQuery.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        return this.db.execute(Cypher.withParamMapping(elseQuery, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(value="apoc.do.case", mode=Mode.WRITE)
    @Description(value="apoc.do.case([condition, query, condition, query, ...], elseQuery:'', params:{}) yield value - given a list of conditional / writing query pairs, executes the query associated with the first conditional evaluating to true (or the else query if none are true) with the given parameters")
    public Stream<MapResult> doWhenCase(@Name(value="conditionals") List<Object> conditionals, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="") Map<String, Object> params) {
        return this.whenCase(conditionals, elseQuery, params);
    }

    public static class RowResult {
        public static final RowResult TOMBSTONE = new RowResult(-1L, null);
        public long row;
        public Map<String, Object> result;

        public RowResult(long row, Map<String, Object> result) {
            this.row = row;
            this.result = result;
        }
    }
}

