/*
 * Decompiled with CFR 0.152.
 */
package apoc.data.url;

import apoc.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class ExtractURL {
    @UserFunction(value="apoc.data.url")
    @Description(value="apoc.data.url('url') as {protocol,host,port,path,query,file,anchor,user} | turn URL into map structure")
    public Map<String, Object> parse(@Name(value="url") String value) {
        if (value == null) {
            return null;
        }
        try {
            URL u = new URL(value);
            Long port = u.getPort() == -1 ? null : Long.valueOf(u.getPort());
            return Util.map("protocol", u.getProtocol(), "user", u.getUserInfo(), "host", u.getHost(), "port", port, "path", u.getPath(), "file", u.getFile(), "query", u.getQuery(), "anchor", u.getRef());
        }
        catch (MalformedURLException exc) {
            return null;
        }
    }
}

