/*
 * Decompiled with CFR 0.152.
 */
package apoc.date;

import apoc.util.Util;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Date {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int MILLIS_IN_SECOND = 1000;
    private static final String UTC_ZONE_ID = "UTC";
    private static final List<TemporalQuery<Consumer<FieldResult>>> DT_FIELDS_SELECTORS = Arrays.asList(Date.temporalQuery(ChronoField.YEAR), Date.temporalQuery(ChronoField.MONTH_OF_YEAR), Date.temporalQuery(ChronoField.DAY_OF_WEEK), Date.temporalQuery(ChronoField.DAY_OF_MONTH), Date.temporalQuery(ChronoField.HOUR_OF_DAY), Date.temporalQuery(ChronoField.MINUTE_OF_HOUR), Date.temporalQuery(ChronoField.SECOND_OF_MINUTE), temporal -> result -> {
        Optional<ZoneId> zone = Optional.ofNullable(TemporalQueries.zone().queryFrom(temporal));
        zone.ifPresent(zoneId -> {
            String displayName = zoneId.getDisplayName(TextStyle.SHORT, Locale.ROOT);
            result.value.put("zoneid", displayName);
            result.zoneid = displayName;
        });
    });

    @UserFunction
    @Description(value="toYears(timestap) or toYears(date[,format]) converts timestamp into floating point years")
    public double toYears(@Name(value="value") Object value, @Name(value="format", defaultValue="yyyy-MM-dd HH:mm:ss") String format) {
        if (value instanceof Number) {
            long time = ((Number)value).longValue();
            return (double)time / 3.1536E10;
        }
        long time = this.parse(value.toString(), "ms", format, null);
        return 1970.0 + (double)time / 3.1536E10;
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.date.expire(node,time,'time-unit') - expire node in given time by setting :TTL label and `ttl` property")
    public void expire(@Name(value="node") Node node, @Name(value="time") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)this.unit(timeUnit).toMillis(time));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.date.expire.in(node,time,'time-unit') - expire node in given time-delta by setting :TTL label and `ttl` property")
    public void expireIn(@Name(value="node") Node node, @Name(value="timeDelta") long time, @Name(value="timeUnit") String timeUnit) {
        node.addLabel(Label.label((String)"TTL"));
        node.setProperty("ttl", (Object)(System.currentTimeMillis() + this.unit(timeUnit).toMillis(time)));
    }

    @UserFunction
    @Description(value="apoc.date.fields('2012-12-23',('yyyy-MM-dd')) - return columns and a map representation of date parsed with the given format with entries for years,months,weekdays,days,hours,minutes,seconds,zoneid")
    public Map<String, Object> fields(@Name(value="date") String date, @Name(value="pattern", defaultValue="yyyy-MM-dd HH:mm:ss") String pattern) {
        if (date == null) {
            return Util.map(new Object[0]);
        }
        DateTimeFormatter fmt = Date.getSafeDateTimeFormatter(pattern);
        TemporalAccessor temporal = fmt.parse(date);
        FieldResult result = new FieldResult();
        for (TemporalQuery<Consumer<FieldResult>> query : DT_FIELDS_SELECTORS) {
            query.queryFrom(temporal).accept(result);
        }
        return result.asMap();
    }

    @UserFunction
    @Description(value="apoc.date.field(12345,('ms|s|m|h|d|month|year'),('TZ')")
    public Long field(@Name(value="time") Long time, @Name(value="unit", defaultValue="d") String unit, @Name(value="timezone", defaultValue="UTC") String timezone) {
        return time == null ? null : Long.valueOf(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.of(timezone)).get(this.chronoField(unit)));
    }

    @UserFunction
    @Description(value="apoc.date.currentTimestamp() - returns System.currentTimeMillis()")
    public long currentTimestamp() {
        return System.currentTimeMillis();
    }

    private TimeUnit unit(String unit) {
        if (unit == null) {
            return TimeUnit.MILLISECONDS;
        }
        switch (unit.toLowerCase()) {
            case "ms": 
            case "milli": 
            case "millis": 
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": 
            case "second": 
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "m": 
            case "minute": 
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "d": 
            case "day": 
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        return TimeUnit.MILLISECONDS;
    }

    private ChronoField chronoField(String unit) {
        switch (unit.toLowerCase()) {
            case "ms": 
            case "milli": 
            case "millis": 
            case "milliseconds": {
                return ChronoField.MILLI_OF_SECOND;
            }
            case "s": 
            case "second": 
            case "seconds": {
                return ChronoField.SECOND_OF_MINUTE;
            }
            case "m": 
            case "minute": 
            case "minutes": {
                return ChronoField.MINUTE_OF_HOUR;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return ChronoField.HOUR_OF_DAY;
            }
            case "d": 
            case "day": 
            case "days": {
                return ChronoField.DAY_OF_MONTH;
            }
            case "w": 
            case "weekday": 
            case "weekdays": {
                return ChronoField.DAY_OF_WEEK;
            }
            case "month": 
            case "months": {
                return ChronoField.MONTH_OF_YEAR;
            }
            case "year": 
            case "years": {
                return ChronoField.YEAR;
            }
        }
        return ChronoField.YEAR;
    }

    @UserFunction
    @Description(value="apoc.date.format(12345,('ms|s|m|h|d'),('yyyy-MM-dd HH:mm:ss zzz'),('TZ')) get string representation of time value optionally using the specified unit (default ms) using specified format (default ISO) and specified time zone (default current TZ)")
    public String format(@Name(value="time") Long time, @Name(value="unit", defaultValue="ms") String unit, @Name(value="format", defaultValue="yyyy-MM-dd HH:mm:ss") String format, @Name(value="timezone", defaultValue="") String timezone) {
        return time == null ? null : this.parse(this.unit(unit).toMillis(time), format, timezone);
    }

    @UserFunction
    @Description(value="apoc.date.toISO8601(12345,('ms|s|m|h|d') return string representation of time in ISO8601 format")
    public String toISO8601(@Name(value="time") Long time, @Name(value="unit", defaultValue="ms") String unit) {
        return time == null ? null : this.parse(this.unit(unit).toMillis(time), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", null);
    }

    @UserFunction
    @Description(value="apoc.date.fromISO8601('yyyy-MM-ddTHH:mm:ss.SSSZ') return number representation of time in EPOCH format")
    public Long fromISO8601(@Name(value="time") String time) {
        return time == null ? null : Long.valueOf(Instant.parse(time).toEpochMilli());
    }

    @UserFunction
    @Description(value="apoc.date.parse('2012-12-23','ms|s|m|h|d','yyyy-MM-dd') parse date string using the specified format into the specified time unit")
    public Long parse(@Name(value="time") String time, @Name(value="unit", defaultValue="ms") String unit, @Name(value="format", defaultValue="yyyy-MM-dd HH:mm:ss") String format, @Name(value="timezone", defaultValue="") String timezone) {
        Long value = Date.parseOrThrow(time, Date.getFormat(format, timezone));
        return value == null ? null : Long.valueOf(this.unit(unit).convert(value, TimeUnit.MILLISECONDS));
    }

    @UserFunction
    @Description(value="apoc.date.systemTimezone() returns the system timezone display name")
    public String systemTimezone() {
        return TimeZone.getDefault().getID();
    }

    @UserFunction
    @Description(value="apoc.date.convert(12345, 'ms', 'd') convert a timestamp in one time unit into one of a different time unit")
    public Long convert(@Name(value="time") long time, @Name(value="unit") String unit, @Name(value="toUnit") String toUnit) {
        return this.unit(toUnit).convert(time, this.unit(unit));
    }

    @UserFunction
    @Description(value="apoc.date.add(12345, 'ms', -365, 'd') given a timestamp in one time unit, adds a value of the specified time unit")
    public Long add(@Name(value="time") long time, @Name(value="unit") String unit, @Name(value="addValue") long addValue, @Name(value="addUnit") String addUnit) {
        long valueToAdd = this.unit(unit).convert(addValue, this.unit(addUnit));
        return time + valueToAdd;
    }

    public String parse(@Name(value="millis") long millis, @Name(value="pattern", defaultValue="yyyy-MM-dd HH:mm:ss") String pattern, @Name(value="timezone") String timezone) {
        return Date.getFormat(pattern, timezone).format(new java.util.Date(millis));
    }

    private static DateFormat getFormat(String pattern, String timezone) {
        String actualPattern = Date.getPattern(pattern);
        SimpleDateFormat format = new SimpleDateFormat(actualPattern);
        if (timezone != null && !"".equals(timezone)) {
            format.setTimeZone(TimeZone.getTimeZone(timezone));
        } else if (!Date.containsTimeZonePattern(actualPattern)) {
            format.setTimeZone(TimeZone.getTimeZone(UTC_ZONE_ID));
        }
        return format;
    }

    private static DateTimeFormatter getSafeDateTimeFormatter(String pattern) {
        DateTimeFormatter safeFormatter = Date.getDateTimeFormatter(pattern);
        if (Locale.UK.equals(safeFormatter.getLocale())) {
            return safeFormatter.withLocale(Locale.ENGLISH);
        }
        return safeFormatter;
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern) {
        String actualPattern = Date.getPattern(pattern);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(actualPattern);
        if (Date.containsTimeZonePattern(actualPattern)) {
            return fmt;
        }
        return fmt.withZone(ZoneId.of(UTC_ZONE_ID));
    }

    private static Long parseOrThrow(String date, DateFormat format) {
        if (date == null) {
            return null;
        }
        try {
            return format.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean containsTimeZonePattern(String pattern) {
        return pattern.matches("[XxZzVO]{1,3}");
    }

    private static String getPattern(String pattern) {
        return pattern == null || "".equals(pattern) ? DEFAULT_FORMAT : pattern;
    }

    private static TemporalQuery<Consumer<FieldResult>> temporalQuery(ChronoField field) {
        return temporal -> result -> {
            if (field.isSupportedBy(temporal)) {
                String key = field.getBaseUnit().toString().toLowerCase();
                long value = field.getFrom(temporal);
                switch (field) {
                    case YEAR: {
                        result.years = value;
                        break;
                    }
                    case MONTH_OF_YEAR: {
                        result.months = value;
                        break;
                    }
                    case DAY_OF_WEEK: {
                        result.weekdays = value;
                        key = "weekdays";
                        break;
                    }
                    case DAY_OF_MONTH: {
                        result.days = value;
                        break;
                    }
                    case HOUR_OF_DAY: {
                        result.hours = value;
                        break;
                    }
                    case MINUTE_OF_HOUR: {
                        result.minutes = value;
                        break;
                    }
                    case SECOND_OF_MINUTE: {
                        result.seconds = value;
                    }
                }
                result.value.put(key, value);
            }
        };
    }

    public static class FieldResult {
        public final Map<String, Object> value = new LinkedHashMap<String, Object>();
        public long years;
        public long months;
        public long days;
        public long weekdays;
        public long hours;
        public long minutes;
        public long seconds;
        public String zoneid;

        public Map<String, Object> asMap() {
            return this.value;
        }
    }
}

