/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CsvHeaderField;
import apoc.export.csv.CsvHeaderFields;
import apoc.export.csv.CsvLoaderConfig;
import apoc.export.csv.CsvLoaderConstants;
import apoc.export.csv.CsvPropertyConverter;
import apoc.export.util.BatchTransaction;
import apoc.export.util.CountingReader;
import apoc.export.util.ProgressReporter;
import apoc.load.LoadCsv;
import apoc.util.FileUtils;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class CsvEntityLoader {
    private final CsvLoaderConfig clc;
    private final ProgressReporter reporter;

    public CsvEntityLoader(CsvLoaderConfig clc, ProgressReporter reporter) {
        this.clc = clc;
        this.reporter = reporter;
    }

    public void loadNodes(String fileName, List<String> labels, GraphDatabaseService db, Map<String, Map<String, Long>> idMapping) throws IOException {
        CountingReader reader = FileUtils.readerFor(fileName);
        String header = CsvEntityLoader.readFirstLine(reader);
        reader.skip(this.clc.getSkipLines() - 1);
        List<CsvHeaderField> fields = CsvHeaderFields.processHeader(header, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
        Optional<CsvHeaderField> idField = fields.stream().filter(f -> "ID".equals(f.getType())).findFirst();
        Optional idAttribute = idField.isPresent() ? Optional.of(idField.get().getName()) : Optional.empty();
        String idSpace = idField.isPresent() ? idField.get().getIdSpace() : "__CSV_DEFAULT_IDSPACE";
        idMapping.putIfAbsent(idSpace, new HashMap());
        Map<String, Long> idspaceIdMapping = idMapping.get(idSpace);
        Map<String, LoadCsv.Mapping> mapping = fields.stream().collect(Collectors.toMap(CsvHeaderField::getName, f -> {
            Map<String, Object> mappingMap = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("type", f.getType()), new AbstractMap.SimpleEntry<String, Boolean>("array", f.isArray())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            return new LoadCsv.Mapping(f.getName(), mappingMap, this.clc.getArrayDelimiter(), false);
        }));
        CSVReader csv = new CSVReader((Reader)reader, this.clc.getDelimiter());
        String[] loadCsvCompatibleHeader = (String[])fields.stream().map(f -> f.getName()).toArray(String[]::new);
        int lineNo = 0;
        try (BatchTransaction tx = new BatchTransaction(db, this.clc.getBatchSize(), this.reporter);){
            for (String[] line : csv.readAll()) {
                EnumSet<LoadCsv.Results> results = EnumSet.of(LoadCsv.Results.map);
                LoadCsv.CSVResult result = new LoadCsv.CSVResult(loadCsvCompatibleHeader, line, ++lineNo, false, mapping, Collections.emptyList(), results);
                Node node = db.createNode();
                if (idField.isPresent()) {
                    idspaceIdMapping.put(result.map.get(idAttribute.get()).toString(), node.getId());
                }
                for (String label : labels) {
                    node.addLabel(Label.label((String)label));
                }
                int props = 0;
                for (CsvHeaderField field : fields) {
                    String name = field.getName();
                    Object value = result.map.get(name);
                    if (field.isMeta()) {
                        List customLabels = (List)value;
                        for (String customLabel : customLabels) {
                            node.addLabel(Label.label((String)customLabel));
                        }
                        continue;
                    }
                    if (field.isId()) {
                        Object idValue = this.clc.getStringIds() ? value : Long.valueOf((String)value);
                        node.setProperty(field.getName(), idValue);
                        ++props;
                        continue;
                    }
                    boolean propertyAdded = CsvPropertyConverter.addPropertyToGraphEntity((Entity)node, field, value);
                    props += propertyAdded ? 1 : 0;
                }
                this.reporter.update(1L, 0L, props++);
            }
        }
    }

    public void loadRelationships(String fileName, String type, GraphDatabaseService db, Map<String, Map<String, Long>> idMapping) throws IOException {
        CountingReader reader = FileUtils.readerFor(fileName);
        String header = CsvEntityLoader.readFirstLine(reader);
        List<CsvHeaderField> fields = CsvHeaderFields.processHeader(header, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
        CsvHeaderField startIdField = fields.stream().filter(f -> "START_ID".equals(f.getType())).findFirst().get();
        CsvHeaderField endIdField = fields.stream().filter(f -> "END_ID".equals(f.getType())).findFirst().get();
        List edgePropertiesFields = fields.stream().filter(field -> !"START_ID".equals(field.getType())).filter(field -> !"END_ID".equals(field.getType())).collect(Collectors.toList());
        Map<String, LoadCsv.Mapping> mapping = fields.stream().collect(Collectors.toMap(CsvHeaderField::getName, f -> {
            Map<String, Object> mappingMap = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("type", f.getType()), new AbstractMap.SimpleEntry<String, Boolean>("array", f.isArray())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            return new LoadCsv.Mapping(f.getName(), mappingMap, this.clc.getArrayDelimiter(), false);
        }));
        CSVReader csv = new CSVReader((Reader)reader, this.clc.getDelimiter());
        String[] loadCsvCompatibleHeader = (String[])fields.stream().map(f -> f.getName()).toArray(String[]::new);
        int lineNo = 0;
        try (BatchTransaction tx = new BatchTransaction(db, this.clc.getBatchSize(), this.reporter);){
            for (String[] line : csv.readAll()) {
                EnumSet<LoadCsv.Results> results = EnumSet.of(LoadCsv.Results.map);
                LoadCsv.CSVResult result = new LoadCsv.CSVResult(loadCsvCompatibleHeader, line, ++lineNo, false, mapping, Collections.emptyList(), results);
                Object startId = result.map.get(CsvLoaderConstants.START_ID_ATTR);
                Long startInternalId = idMapping.get(startIdField.getIdSpace()).get(startId);
                if (startInternalId == null) {
                    throw new IllegalStateException("Node for id space " + endIdField.getIdSpace() + " and id " + startId + " not found");
                }
                Node source = db.getNodeById(startInternalId.longValue());
                Object endId = result.map.get(CsvLoaderConstants.END_ID_ATTR);
                Long endInternalId = idMapping.get(endIdField.getIdSpace()).get(endId);
                if (endInternalId == null) {
                    throw new IllegalStateException("Node for id space " + endIdField.getIdSpace() + " and id " + endId + " not found");
                }
                Node target = db.getNodeById(endInternalId.longValue());
                Object overridingType = result.map.get(CsvLoaderConstants.TYPE_ATTR);
                String currentType = overridingType != null && !((String)overridingType).isEmpty() ? (String)overridingType : type;
                Relationship rel = source.createRelationshipTo(target, RelationshipType.withName((String)currentType));
                int props = 0;
                for (CsvHeaderField field2 : edgePropertiesFields) {
                    String name;
                    Object value;
                    boolean propertyAdded = CsvPropertyConverter.addPropertyToGraphEntity((Entity)rel, field2, value = result.map.get(name = field2.getName()));
                    props += propertyAdded ? 1 : 0;
                }
                this.reporter.update(0L, 1L, props);
            }
        }
    }

    private static String readFirstLine(CountingReader reader) throws IOException {
        char c;
        int i;
        String line = "";
        while ((i = reader.read()) != 0 && (c = (char)i) != '\n') {
            line = line + c;
        }
        return line;
    }
}

