/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.util.ExportConfig;
import apoc.export.util.Format;
import apoc.export.util.FormatUtils;
import apoc.export.util.MetaInformation;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import com.opencsv.CSVWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class CsvFormat
implements Format {
    private final GraphDatabaseService db;

    public CsvFormat(GraphDatabaseService db) {
        this.db = db;
    }

    @Override
    public ProgressInfo load(Reader reader, Reporter reporter, ExportConfig config) throws Exception {
        return null;
    }

    @Override
    public ProgressInfo dump(SubGraph graph, Writer writer, Reporter reporter, ExportConfig config) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            CSVWriter out = config.isQuotes() ? new CSVWriter(writer, config.getDelimChar(), '\"') : new CSVWriter(writer, config.getDelimChar());
            this.writeAll(graph, reporter, config, out);
            tx.success();
            reporter.done();
            writer.close();
            ProgressInfo progressInfo = reporter.getTotal();
            return progressInfo;
        }
    }

    public ProgressInfo dump(Result result, Writer writer, Reporter reporter, ExportConfig config) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            CSVWriter out = new CSVWriter(writer, config.getDelimChar());
            String[] header = this.writeResultHeader(result, out);
            String[] data = new String[header.length];
            result.accept(row -> {
                for (int col = 0; col < header.length; ++col) {
                    Object value = row.get(header[col]);
                    data[col] = FormatUtils.toString(value);
                    reporter.update(value instanceof Node ? 1L : 0L, value instanceof Relationship ? 1L : 0L, value instanceof PropertyContainer ? 0L : 1L);
                }
                out.writeNext(data);
                reporter.nextRow();
                return true;
            });
            tx.success();
            reporter.done();
            writer.close();
            ProgressInfo progressInfo = reporter.getTotal();
            return progressInfo;
        }
    }

    public String[] writeResultHeader(Result result, CSVWriter out) {
        List columns = result.columns();
        int cols = columns.size();
        String[] header = columns.toArray(new String[cols]);
        out.writeNext(header);
        return header;
    }

    public void writeAll(SubGraph graph, Reporter reporter, ExportConfig config, CSVWriter out) {
        Map<String, Class> nodePropTypes = MetaInformation.collectPropTypesForNodes(graph);
        Map<String, Class> relPropTypes = MetaInformation.collectPropTypesForRelationships(graph);
        List<String> nodeHeader = this.generateHeader(nodePropTypes, config.useTypes(), "_id:id", "_labels:label");
        List<String> relHeader = this.generateHeader(relPropTypes, config.useTypes(), "_start:id", "_end:id", "_type:label");
        ArrayList<String> header = new ArrayList<String>(nodeHeader);
        header.addAll(relHeader);
        out.writeNext(header.toArray(new String[header.size()]));
        int cols = header.size();
        this.writeNodes(graph, out, reporter, nodePropTypes, cols, config.getBatchSize());
        this.writeRels(graph, out, reporter, relPropTypes, cols, nodeHeader.size(), config.getBatchSize());
    }

    public void writeAll2(SubGraph graph, Reporter reporter, ExportConfig config, CSVWriter out) {
        this.writeNodes(graph, out, reporter, config);
        this.writeRels(graph, out, reporter, config);
    }

    private List<String> generateHeader(Map<String, Class> propTypes, boolean useTypes, String ... starters) {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, starters);
        for (Map.Entry<String, Class> entry : propTypes.entrySet()) {
            String type = MetaInformation.typeFor(entry.getValue(), null);
            if (type == null || type.equals("string") || !useTypes) {
                result.add(entry.getKey());
                continue;
            }
            result.add(entry.getKey() + ":" + type);
        }
        if (!useTypes) {
            return result.stream().map(s -> s.split(":")[0]).collect(Collectors.toList());
        }
        return result;
    }

    private void writeNodes(SubGraph graph, CSVWriter out, Reporter reporter, ExportConfig config) {
        Map<String, Class> nodePropTypes = MetaInformation.collectPropTypesForNodes(graph);
        List<String> nodeHeader = this.generateHeader(nodePropTypes, config.useTypes(), "_id:id", "_labels:label");
        String[] header = nodeHeader.toArray(new String[nodeHeader.size()]);
        out.writeNext(header);
        int cols = header.length;
        this.writeNodes(graph, out, reporter, nodePropTypes, cols, config.getBatchSize());
    }

    private void writeNodes(SubGraph graph, CSVWriter out, Reporter reporter, Map<String, Class> nodePropTypes, int cols, int batchSize) {
        String[] row = new String[cols];
        int nodes = 0;
        for (Node node : graph.getNodes()) {
            row[0] = String.valueOf(node.getId());
            row[1] = MetaInformation.getLabelsString(node);
            this.collectProps(nodePropTypes.keySet(), (PropertyContainer)node, reporter, row, 2);
            out.writeNext(row);
            if (batchSize != -1 && ++nodes % batchSize != 0) continue;
            reporter.update(nodes, 0L, 0L);
            nodes = 0;
        }
        if (nodes > 0) {
            reporter.update(nodes, 0L, 0L);
        }
    }

    private void collectProps(Collection<String> fields, PropertyContainer pc, Reporter reporter, String[] row, int offset) {
        for (String field : fields) {
            if (pc.hasProperty(field)) {
                row[offset] = FormatUtils.toString(pc.getProperty(field));
                reporter.update(0L, 0L, 1L);
            } else {
                row[offset] = "";
            }
            ++offset;
        }
    }

    private void writeRels(SubGraph graph, CSVWriter out, Reporter reporter, ExportConfig config) {
        Map<String, Class> relPropTypes = MetaInformation.collectPropTypesForRelationships(graph);
        List<String> header = this.generateHeader(relPropTypes, config.useTypes(), "_start:id", "_end:id", "_type:label");
        out.writeNext(header.toArray(new String[header.size()]));
        int cols = header.size();
        int offset = 0;
        this.writeRels(graph, out, reporter, relPropTypes, cols, offset, config.getBatchSize());
    }

    private void writeRels(SubGraph graph, CSVWriter out, Reporter reporter, Map<String, Class> relPropTypes, int cols, int offset, int batchSize) {
        String[] row = new String[cols];
        int rels = 0;
        for (Relationship rel : graph.getRelationships()) {
            row[offset] = String.valueOf(rel.getStartNode().getId());
            row[offset + 1] = String.valueOf(rel.getEndNode().getId());
            row[offset + 2] = rel.getType().name();
            this.collectProps(relPropTypes.keySet(), (PropertyContainer)rel, reporter, row, 3 + offset);
            out.writeNext(row);
            if (batchSize != -1 && ++rels % batchSize != 0) continue;
            reporter.update(0L, 1L, 0L);
            rels = 0;
        }
        if (rels > 0) {
            reporter.update(0L, rels, 0L);
        }
    }
}

