/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import java.util.Map;

public class CsvLoaderConfig {
    public static final String DELIMITER = "delimiter";
    public static final String ARRAY_DELIMITER = "arrayDelimiter";
    public static final String QUOTATION_CHARACTER = "quotationCharacter";
    public static final String STRING_IDS = "stringIds";
    public static final String SKIP_LINES = "skipLines";
    public static final String BATCH_SIZE = "batchSize";
    public static char DELIMITER_DEFAULT = (char)44;
    public static char ARRAY_DELIMITER_DEFAULT = (char)59;
    public static char QUOTATION_CHARACTER_DEFAULT = (char)34;
    public static boolean STRING_IDS_DEFAULT = true;
    public static int SKIP_LINES_DEFAULT = 1;
    public static int BATCH_SIZE_DEFAULT = 2000;
    private final char delimiter;
    private final char arrayDelimiter;
    private final char quotationCharacter;
    private final boolean stringIds;
    private final int skipLines;
    private final int batchSize;

    private CsvLoaderConfig(Builder builder) {
        this.delimiter = builder.delimiter;
        this.arrayDelimiter = builder.arrayDelimiter;
        this.quotationCharacter = builder.quotationCharacter;
        this.stringIds = builder.stringIds;
        this.skipLines = builder.skipLines;
        this.batchSize = builder.batchSize;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public char getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    public char getQuotationCharacter() {
        return this.quotationCharacter;
    }

    public boolean getStringIds() {
        return this.stringIds;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CsvLoaderConfig from(Map<String, Object> config) {
        Builder builder = CsvLoaderConfig.builder();
        if (config.get(DELIMITER) != null) {
            builder.delimiter(((Character)config.get(DELIMITER)).charValue());
        }
        if (config.get(ARRAY_DELIMITER) != null) {
            builder.arrayDelimiter(((Character)config.get(ARRAY_DELIMITER)).charValue());
        }
        if (config.get(QUOTATION_CHARACTER) != null) {
            builder.quotationCharacter(((Character)config.get(QUOTATION_CHARACTER)).charValue());
        }
        if (config.get(STRING_IDS) != null) {
            builder.stringIds((Boolean)config.get(STRING_IDS));
        }
        if (config.get(SKIP_LINES) != null) {
            builder.skipLines((Integer)config.get(SKIP_LINES));
        }
        if (config.get(BATCH_SIZE) != null) {
            builder.batchSize((Integer)config.get(BATCH_SIZE));
        }
        return builder.build();
    }

    public static final class Builder {
        private char delimiter = DELIMITER_DEFAULT;
        private char arrayDelimiter = ARRAY_DELIMITER_DEFAULT;
        private char quotationCharacter = QUOTATION_CHARACTER_DEFAULT;
        private boolean stringIds = STRING_IDS_DEFAULT;
        private int skipLines = SKIP_LINES_DEFAULT;
        private int batchSize = BATCH_SIZE_DEFAULT;

        private Builder() {
        }

        public Builder delimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder arrayDelimiter(char arrayDelimiter) {
            this.arrayDelimiter = arrayDelimiter;
            return this;
        }

        public Builder quotationCharacter(char quotationCharacter) {
            this.quotationCharacter = quotationCharacter;
            return this;
        }

        public Builder stringIds(boolean stringIds) {
            this.stringIds = stringIds;
            return this;
        }

        public Builder skipLines(int skipLines) {
            this.skipLines = skipLines;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public CsvLoaderConfig build() {
            return new CsvLoaderConfig(this);
        }
    }
}

