/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.Description;
import apoc.Pools;
import apoc.export.csv.CsvFormat;
import apoc.export.util.ExportConfig;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.FileUtils;
import apoc.util.QueueBasedSpliterator;
import apoc.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportCSV {
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;

    public ExportCSV(GraphDatabaseService db) {
        this.db = db;
    }

    public ExportCSV() {
    }

    @Procedure
    @Description(value="apoc.export.csv.all(file,config) - exports whole database as csv to the provided file")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.db), Util.relCount(this.db));
        return this.exportCsv(fileName, source, new DatabaseSubGraph(this.db), config);
    }

    @Procedure
    @Description(value="apoc.export.csv.data(nodes,rels,file,config) - exports given nodes and relationships as csv to the provided file")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new NodesAndRelsSubGraph(this.db, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.csv.graph(graph,file,config) - exports given graph object as csv to the provided file")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new NodesAndRelsSubGraph(this.db, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.csv.query(query,file,{config,...,params:{params}}) - exports results from the cypher kernelTransaction as csv to the provided file")
    public Stream<ProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.db.execute(query, params);
        String source = String.format("kernelTransaction: cols(%d)", result.columns().size());
        return this.exportCsv(fileName, source, result, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<ProgressInfo> exportCsv(@Name(value="file") String fileName, String source, Object data, Map<String, Object> config) throws Exception {
        FileUtils.checkWriteAllowed();
        ExportConfig c = new ExportConfig(config);
        ProgressInfo progressInfo = new ProgressInfo(fileName, source, "csv");
        progressInfo.batchSize = c.getBatchSize();
        ProgressReporter reporter = new ProgressReporter(null, null, progressInfo);
        PrintWriter printWriter = FileUtils.getPrintWriter(fileName, null);
        CsvFormat exporter = new CsvFormat(this.db);
        if (c.streamStatements()) {
            Future<Boolean> future = null;
            try {
                StringWriter writer = new StringWriter(10000);
                ArrayBlockingQueue queue = new ArrayBlockingQueue(1000);
                ProgressReporter reporterWithConsumer = reporter.withConsumer(pi -> queue.offer(pi == ProgressInfo.EMPTY ? ProgressInfo.EMPTY : new ProgressInfo((ProgressInfo)pi).drain(writer)));
                future = Util.inTxFuture(Pools.DEFAULT, this.db, () -> {
                    this.dump(data, c, reporterWithConsumer, writer, exporter);
                    return true;
                });
                QueueBasedSpliterator<ProgressInfo> spliterator = new QueueBasedSpliterator<ProgressInfo>(queue, ProgressInfo.EMPTY, this.terminationGuard);
                Stream<ProgressInfo> stream = StreamSupport.stream(spliterator, false);
                return stream;
            }
            finally {
                Util.waitForFutures(Collections.singletonList(future));
            }
        }
        this.dump(data, c, reporter, printWriter, exporter);
        return reporter.stream();
    }

    private void dump(Object data, ExportConfig c, ProgressReporter reporter, Writer printWriter, CsvFormat exporter) throws Exception {
        if (data instanceof SubGraph) {
            exporter.dump((SubGraph)data, printWriter, (Reporter)reporter, c);
        }
        if (data instanceof Result) {
            exporter.dump((Result)data, printWriter, (Reporter)reporter, c);
        }
    }
}

