/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher.formatter;

import apoc.export.cypher.formatter.CypherFormat;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

abstract class AbstractCypherFormatter
implements CypherFormatter {
    AbstractCypherFormatter() {
    }

    @Override
    public String statementForCleanUp(int batchSize) {
        return "MATCH (n:" + CypherFormatterUtils.Q_UNIQUE_ID_LABEL + ")  WITH n LIMIT " + batchSize + " REMOVE n:" + CypherFormatterUtils.Q_UNIQUE_ID_LABEL + " REMOVE n." + CypherFormatterUtils.quote("UNIQUE IMPORT ID") + ";";
    }

    @Override
    public String statementForIndex(String label, Iterable<String> keys) {
        return "CREATE INDEX ON :" + CypherFormatterUtils.quote(label) + "(" + CypherFormatterUtils.quote(keys) + ");";
    }

    @Override
    public String statementForConstraint(String label, String key) {
        return "CREATE CONSTRAINT ON (node:" + CypherFormatterUtils.quote(label) + ") ASSERT node." + CypherFormatterUtils.quote(key) + " IS UNIQUE;";
    }

    protected String mergeStatementForNode(CypherFormat cypherFormat, Node node, Map<String, String> uniqueConstraints, Set<String> indexedProperties, Set<String> indexNames) {
        StringBuilder result = new StringBuilder(1000);
        result.append("MERGE ");
        result.append(CypherFormatterUtils.formatNodeLookup("n", node, uniqueConstraints, indexNames));
        if (node.getPropertyKeys().iterator().hasNext()) {
            String notUniqueProperties = CypherFormatterUtils.formatNotUniqueProperties("n", node, uniqueConstraints, indexedProperties, false);
            String notUniqueLabels = CypherFormatterUtils.formatNotUniqueLabels("n", node, uniqueConstraints);
            if (!"".equals(notUniqueProperties) || !"".equals(notUniqueLabels)) {
                result.append(cypherFormat.equals((Object)CypherFormat.ADD_STRUCTURE) ? " ON CREATE SET " : " SET ");
                result.append(notUniqueProperties);
                result.append(!"".equals(notUniqueProperties) && !"".equals(notUniqueLabels) ? ", " : "");
                result.append(notUniqueLabels);
            }
        }
        result.append(";");
        return result.toString();
    }

    public String mergeStatementForRelationship(CypherFormat cypherFormat, Relationship relationship, Map<String, String> uniqueConstraints, Set<String> indexedProperties) {
        StringBuilder result = new StringBuilder(1000);
        result.append("MATCH ");
        result.append(CypherFormatterUtils.formatNodeLookup("n1", relationship.getStartNode(), uniqueConstraints, indexedProperties));
        result.append(", ");
        result.append(CypherFormatterUtils.formatNodeLookup("n2", relationship.getEndNode(), uniqueConstraints, indexedProperties));
        result.append(" MERGE (n1)-[r:" + CypherFormatterUtils.quote(relationship.getType().name()) + "]->(n2)");
        if (relationship.getPropertyKeys().iterator().hasNext()) {
            result.append(cypherFormat.equals((Object)CypherFormat.UPDATE_STRUCTURE) ? " ON CREATE SET " : " SET ");
            result.append(CypherFormatterUtils.formatRelationshipProperties("r", relationship, false));
        }
        result.append(";");
        return result.toString();
    }
}

