/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.cypher.formatter.CypherFormat;
import apoc.export.util.ExportFormat;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class ExportConfig {
    public static final char QUOTECHAR = '\"';
    public static final int DEFAULT_BATCH_SIZE = 20000;
    public static final String DEFAULT_DELIM = ",";
    private final boolean streamStatements;
    private int batchSize = 20000;
    private boolean silent = false;
    private String delim = ",";
    private boolean quotes;
    private boolean useTypes = false;
    private boolean nodesOfRelationships;
    private ExportFormat format;
    private CypherFormat cypherFormat;
    private final Map<String, Object> config;

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public char getDelimChar() {
        return this.delim.charAt(0);
    }

    public String getDelim() {
        return this.delim;
    }

    public boolean isQuotes() {
        return this.quotes;
    }

    public boolean useTypes() {
        return this.useTypes;
    }

    public ExportFormat getFormat() {
        return this.format;
    }

    public CypherFormat getCypherFormat() {
        return this.cypherFormat;
    }

    public ExportConfig(Map<String, Object> config) {
        config = config != null ? config : Collections.emptyMap();
        this.silent = Util.toBoolean(config.getOrDefault("silent", false));
        this.batchSize = ((Number)config.getOrDefault("batchSize", 20000)).intValue();
        this.delim = ExportConfig.delim(config.getOrDefault("d", String.valueOf(DEFAULT_DELIM)).toString());
        this.quotes = Util.toBoolean(config.get("quotes"));
        this.useTypes = Util.toBoolean(config.get("useTypes"));
        this.nodesOfRelationships = Util.toBoolean(config.get("nodesOfRelationships"));
        this.format = ExportFormat.fromString((String)config.getOrDefault("format", "neo4j-shell"));
        this.cypherFormat = CypherFormat.fromString((String)config.getOrDefault("cypherFormat", "create"));
        this.config = config;
        this.streamStatements = Util.toBoolean(config.get("streamStatements")) || Util.toBoolean(config.get("stream"));
    }

    public boolean getRelsInBetween() {
        return this.nodesOfRelationships;
    }

    private static String delim(String value) {
        if (value.length() == 1) {
            return value;
        }
        if (value.contains("\\t")) {
            return String.valueOf('\t');
        }
        if (value.contains(" ")) {
            return " ";
        }
        throw new RuntimeException("Illegal delimiter '" + value + "'");
    }

    public ExportConfig withTypes() {
        this.useTypes = true;
        return this;
    }

    public String defaultRelationshipType() {
        return this.config.getOrDefault("defaultRelationshipType", "RELATED").toString();
    }

    public boolean readLabels() {
        return Util.toBoolean(this.config.getOrDefault("readLabels", false));
    }

    public boolean storeNodeIds() {
        return Util.toBoolean(this.config.getOrDefault("storeNodeIds", false));
    }

    public boolean separateFiles() {
        return Util.toBoolean(this.config.getOrDefault("separateFiles", false));
    }

    private ExportFormat format(Object format) {
        return format != null && format instanceof String ? ExportFormat.fromString((String)format) : ExportFormat.NEO4J_SHELL;
    }

    public boolean streamStatements() {
        return this.streamStatements;
    }
}

