/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.cypher.formatter.CypherFormatterUtils;

public enum ExportFormat {
    NEO4J_SHELL("neo4j-shell", String.format("COMMIT%n", new Object[0]), String.format("BEGIN%n", new Object[0]), String.format("SCHEMA AWAIT%n", new Object[0]), ""),
    CYPHER_SHELL("cypher-shell", String.format(":commit%n", new Object[0]), String.format(":begin%n", new Object[0]), "", "CALL db.awaitIndex('%s(%s)');%n"),
    PLAIN_FORMAT("plain", "", "", "", "");

    private final String format;
    private String commit;
    private String begin;
    private String indexAwait;
    private String schemaAwait;

    private ExportFormat(String format, String commit, String begin, String schemaAwait, String indexAwait) {
        this.format = format;
        this.begin = begin;
        this.commit = commit;
        this.schemaAwait = schemaAwait;
        this.indexAwait = indexAwait;
    }

    public static final ExportFormat fromString(String format) {
        if (format != null && !format.isEmpty()) {
            for (ExportFormat exportFormat : ExportFormat.values()) {
                if (!exportFormat.format.equalsIgnoreCase(format)) continue;
                return exportFormat;
            }
        }
        return NEO4J_SHELL;
    }

    public String begin() {
        return this.begin;
    }

    public String commit() {
        return this.commit;
    }

    public String schemaAwait() {
        return this.schemaAwait;
    }

    public String indexAwait(String label, Iterable<String> properties) {
        return String.format(this.indexAwait, CypherFormatterUtils.label(label), CypherFormatterUtils.quote(properties));
    }
}

