/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.util.Util;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class FormatUtils {
    public static DecimalFormat decimalFormat = new DecimalFormat(){
        {
            this.setMaximumFractionDigits(340);
            this.setGroupingUsed(false);
            this.setDecimalSeparatorAlwaysShown(false);
            DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            this.setDecimalFormatSymbols(symbols);
        }
    };

    public static String formatNumber(Number value) {
        if (value == null) {
            return null;
        }
        return decimalFormat.format(value);
    }

    public static String formatString(Object value) {
        return "\"" + String.valueOf(value).replaceAll("\\\\", "\\\\\\\\").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t").replaceAll("\"", "\\\\\"") + "\"";
    }

    public static String joinLabels(Node node, String delimiter) {
        return StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).sorted().collect(Collectors.joining(delimiter));
    }

    public static Map<String, Object> toMap(PropertyContainer pc) {
        if (pc == null) {
            return null;
        }
        if (pc instanceof Node) {
            Node node = (Node)pc;
            return Util.map("id", node.getId(), "labels", Util.labelStrings(node), "properties", pc.getAllProperties());
        }
        if (pc instanceof Relationship) {
            Relationship rel = (Relationship)pc;
            return Util.map("id", rel.getId(), "type", rel.getType().name(), "start", rel.getStartNode().getId(), "end", rel.getEndNode().getId(), "properties", pc.getAllProperties());
        }
        throw new RuntimeException("Invalid graph element " + pc);
    }

    public static String toString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Path) {
            return FormatUtils.toString(StreamSupport.stream(((Path)value).spliterator(), false).map(FormatUtils::toMap).collect(Collectors.toList()));
        }
        if (value instanceof PropertyContainer) {
            return Util.toJson(FormatUtils.toMap((PropertyContainer)value));
        }
        if (value.getClass().isArray() || value instanceof Iterable || value instanceof Map) {
            return Util.toJson(value);
        }
        if (value instanceof Number) {
            return FormatUtils.formatNumber((Number)value);
        }
        return value.toString();
    }
}

