/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate;

import apoc.generate.BaseGraphGenerator;
import apoc.generate.config.GeneratorConfiguration;
import apoc.generate.relationship.RelationshipGenerator;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Pair;

public class Neo4jGraphGenerator
extends BaseGraphGenerator {
    private final GraphDatabaseService database;

    public Neo4jGraphGenerator(GraphDatabaseService database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Long> generateNodes(GeneratorConfiguration config) {
        ArrayList<Long> nodes = new ArrayList<Long>();
        int numberOfNodes = config.getNumberOfNodes();
        try (Transaction tx = this.database.beginTx();){
            for (int i = 1; i <= numberOfNodes; ++i) {
                nodes.add(config.getNodeCreator().createNode(this.database).getId());
                if (i % config.getBatchSize() != 0) continue;
                tx.success();
                tx.close();
                tx = this.database.beginTx();
            }
            tx.success();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateRelationships(GeneratorConfiguration config, List<Long> nodes) {
        RelationshipGenerator relationshipGenerator = config.getRelationshipGenerator();
        List<Pair<Integer, Integer>> relationships = relationshipGenerator.generateEdges();
        try (Transaction tx = this.database.beginTx();){
            int i = 0;
            for (Pair<Integer, Integer> input : relationships) {
                Node first = this.database.getNodeById(nodes.get((Integer)input.first()).longValue());
                Node second = this.database.getNodeById(nodes.get((Integer)input.other()).longValue());
                config.getRelationshipCreator().createRelationship(first, second);
                if (++i % config.getBatchSize() != 0) continue;
                tx.success();
                tx.close();
                tx = this.database.beginTx();
            }
            tx.success();
        }
    }
}

