/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.relationship;

import apoc.generate.config.BarabasiAlbertConfig;
import apoc.generate.config.NumberOfNodesBasedConfig;
import apoc.generate.relationship.BaseRelationshipGenerator;
import apoc.generate.relationship.CompleteGraphRelationshipGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.neo4j.helpers.collection.Pair;

public class BarabasiAlbertRelationshipGenerator
extends BaseRelationshipGenerator<BarabasiAlbertConfig> {
    private final Random random = new Random();

    public BarabasiAlbertRelationshipGenerator(BarabasiAlbertConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<Pair<Integer, Integer>> doGenerateEdges() {
        int edgesPerNewNode = ((BarabasiAlbertConfig)this.getConfiguration()).getEdgesPerNewNode();
        long numberOfNodes = ((BarabasiAlbertConfig)this.getConfiguration()).getNumberOfNodes();
        List<Pair<Integer, Integer>> edges = new CompleteGraphRelationshipGenerator(new NumberOfNodesBasedConfig(edgesPerNewNode + 1)).doGenerateEdges();
        HashSet<Integer> omit = new HashSet<Integer>(edgesPerNewNode);
        int source = edgesPerNewNode + 1;
        while ((long)source < numberOfNodes) {
            omit.clear();
            for (int edge = 0; edge < edgesPerNewNode; ++edge) {
                int target;
                do {
                    Pair<Integer, Integer> randomEdge = edges.get(this.random.nextInt(edges.size()));
                    int n = target = this.random.nextBoolean() ? ((Integer)randomEdge.first()).intValue() : ((Integer)randomEdge.other()).intValue();
                } while (omit.contains(target));
                omit.add(target);
                edges.add((Pair<Integer, Integer>)Pair.of((Object)target, (Object)source));
            }
            ++source;
        }
        return edges;
    }
}

