/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.index.FreeTextSearch;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

class FreeTextQueryParser
extends QueryParser {
    private static char[] WILDCARDS = new char[]{'?', '*'};
    private static final ThreadLocal<QueryParser> PARSER = new ThreadLocal<QueryParser>(){

        @Override
        protected QueryParser initialValue() {
            return new FreeTextQueryParser(false);
        }
    };
    private static final ThreadLocal<QueryParser> PARSER_ALLOWING_LEADING_WILDCARDS = new ThreadLocal<QueryParser>(){

        @Override
        protected QueryParser initialValue() {
            return new FreeTextQueryParser(true);
        }
    };

    static Query parseFreeTextQuery(String query) throws ParseException {
        boolean useWildCardParser = false;
        for (int i = 0; i < WILDCARDS.length; ++i) {
            if (query.charAt(0) != WILDCARDS[i]) continue;
            useWildCardParser = true;
            break;
        }
        ThreadLocal<QueryParser> parser = useWildCardParser ? PARSER_ALLOWING_LEADING_WILDCARDS : PARSER;
        return parser.get().parse(query);
    }

    private FreeTextQueryParser(boolean allowLeadingWildcard) {
        super("search", FreeTextSearch.analyzer());
        this.setAllowLeadingWildcard(allowLeadingWildcard);
    }

    protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        if (!"search".equals(field)) {
            Double num1 = FreeTextQueryParser.parseNumber(part1);
            Double num2 = FreeTextQueryParser.parseNumber(part2);
            if (!(num1 == null && num2 == null || num1 == null && part1 != null || num2 == null && part2 != null)) {
                return NumericRangeQuery.newDoubleRange((String)field, (Double)num1, (Double)num2, (boolean)startInclusive, (boolean)endInclusive);
            }
        }
        return super.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    private static Double parseNumber(String number) {
        try {
            return number == null ? null : Double.valueOf(Double.parseDouble(number));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

