/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.ApocKernelExtensionFactory;
import apoc.Pools;
import apoc.index.FreeTextQueryParser;
import apoc.result.WeightedNodeResult;
import apoc.util.AsyncStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.search.Sort;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.explicit.LuceneIndexImplementation;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.scheduler.JobScheduler;

public class FreeTextSearch {
    @Context
    public GraphDatabaseAPI db;
    @Context
    public Log log;
    private static final Map<String, String> CONFIG = LuceneIndexImplementation.FULLTEXT_CONFIG;
    static final String KEY = "search";
    private static final JobScheduler.Group GROUP = new JobScheduler.Group(FreeTextSearch.class.getSimpleName());

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.index.addAllNodes('name',{label1:['prop1',...],...}, {options}) YIELD type, name, config - create a free text search index")
    public Stream<IndexStats> addAllNodes(@Name(value="index") String index, @Name(value="structure") Map<String, List<String>> structure, @Name(value="options", defaultValue="") Map<String, Object> options) {
        if (structure.isEmpty()) {
            throw new IllegalArgumentException("No structure given.");
        }
        return AsyncStream.async(this.executor(), "Creating index '" + index + "'", result -> this.populate(this.index(index, structure, options), structure, (Consumer<IndexStats>)result));
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.index.addAllNodesExtended('name',{label1:['prop1',...],...}, {options}) YIELD type, name, config - create a free text search index with special options")
    @Deprecated
    public Stream<IndexStats> addAllNodesExtended(@Name(value="index") String index, @Name(value="structure") Map<String, List<String>> structure, @Name(value="options") Map<String, Object> options) {
        return this.addAllNodes(index, structure, options);
    }

    @Procedure(mode=Mode.READ)
    @Description(value="apoc.index.search('name', 'query', [maxNumberOfResults]) YIELD node, weight - search for nodes in the free text index matching the given query")
    public Stream<WeightedNodeResult> search(@Name(value="index") String index, @Name(value="query") String query, @Name(value="numberOfResults", defaultValue="100") long maxNumberOfresults) throws Exception {
        if (!this.db.index().existsForNodes(index)) {
            return Stream.empty();
        }
        QueryContext queryParam = new QueryContext((Object)FreeTextQueryParser.parseFreeTextQuery(query)).sort(Sort.RELEVANCE);
        if (maxNumberOfresults != -1L) {
            queryParam = queryParam.top((int)maxNumberOfresults);
        }
        return this.toWeightedNodeResult((IndexHits<Node>)this.db.index().forNodes(index).query((Object)queryParam));
    }

    private Stream<WeightedNodeResult> toWeightedNodeResult(IndexHits<Node> hits) {
        ArrayList<WeightedNodeResult> results = new ArrayList<WeightedNodeResult>(hits.size());
        while (hits.hasNext()) {
            try {
                Node node = (Node)hits.next();
                node.getGraphDatabase();
                results.add(new WeightedNodeResult(node, hits.currentScore()));
            }
            catch (NotFoundException notFoundException) {}
        }
        return results.stream();
    }

    private static Stream<WeightedNodeResult> result(final IndexHits<Node> hits) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<WeightedNodeResult>(){

            @Override
            public boolean hasNext() {
                return hits.hasNext();
            }

            @Override
            public WeightedNodeResult next() {
                Node node = (Node)hits.next();
                float weight = hits.currentScore();
                return new WeightedNodeResult(node, weight);
            }
        }, 0), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate(Index<Node> index, Map<String, List<String>> config, Consumer<IndexStats> result) {
        Map<String, String[]> structure = this.convertStructure(config);
        HashMap<LabelProperty, Counter> stats = new HashMap<LabelProperty, Counter>();
        try (Transaction tx = this.db.beginTx();){
            int batch = 0;
            for (Node node : this.db.getAllNodes()) {
                boolean indexed = false;
                for (Label label : node.getLabels()) {
                    String[] keys = structure.get(label.name());
                    if (keys == null) continue;
                    indexed = true;
                    Map properties = keys.length == 0 ? node.getAllProperties() : node.getProperties(keys);
                    for (Map.Entry entry : properties.entrySet()) {
                        Object value = entry.getValue();
                        index.add((PropertyContainer)node, KEY, (Object)value.toString());
                        if (value instanceof Number) {
                            value = ValueContext.numeric((Number)((Number)value).doubleValue());
                        }
                        index.add((PropertyContainer)node, label.name() + "." + (String)entry.getKey(), value);
                        ++stats.computeIfAbsent(new LabelProperty((String)label.name(), (String)((String)entry.getKey())), (Function<LabelProperty, Counter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$populate$1(apoc.index.FreeTextSearch$LabelProperty ), (Lapoc/index/FreeTextSearch$LabelProperty;)Lapoc/index/FreeTextSearch$Counter;)()).count;
                    }
                }
                if (!indexed || ++batch != 50000) continue;
                batch = 0;
                tx.success();
                tx.close();
                tx = this.db.beginTx();
            }
            tx.success();
        }
        stats.forEach((key, counter) -> result.accept(key.stats((Counter)counter)));
    }

    private Map<String, String[]> convertStructure(Map<String, List<String>> config) {
        LinkedHashMap<String, String[]> structure = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : config.entrySet()) {
            List<String> props = entry.getValue();
            structure.put(entry.getKey(), props.toArray(new String[props.size()]));
        }
        return structure;
    }

    private Index<Node> index(String index, Map<String, List<String>> structure, Map<String, Object> options) {
        HashMap<String, String> config = new HashMap<String, String>(CONFIG);
        try (Transaction tx = this.db.beginTx();){
            if (this.db.index().existsForNodes(index)) {
                Index old = this.db.index().forNodes(index);
                HashMap oldConfig = new HashMap(this.db.index().getConfiguration(old));
                this.log.info("Dropping existing index '%s', with config: %s", new Object[]{index, oldConfig});
                old.delete();
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var6_6 = null;
        try {
            this.updateConfigFromParameters(config, structure);
            options.forEach((k, v) -> config.put((String)k, String.valueOf(v)));
            this.log.info("Creating or updating index '%s' with config '%s'", new Object[]{index, config});
            Index nodeIndex = this.db.index().forNodes(index, config);
            this.resetIndexUpdateConfiguration();
            tx.success();
            Index index2 = nodeIndex;
            return index2;
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void resetIndexUpdateConfiguration() {
        try {
            ApocKernelExtensionFactory.ApocLifecycle apocLifecycle = (ApocKernelExtensionFactory.ApocLifecycle)((Object)this.db.getDependencyResolver().resolveDependency(ApocKernelExtensionFactory.ApocLifecycle.class));
            if (apocLifecycle != null) {
                apocLifecycle.getIndexUpdateLifeCycle().resetConfiguration();
            }
        }
        catch (Exception e) {
            this.log.error("failed to reset index update configuration", (Throwable)e);
        }
    }

    private void updateConfigFromParameters(Map<String, String> config, Map<String, List<String>> structure) {
        Iterator<String> it = config.keySet().iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith("keysForLabel:")) continue;
            it.remove();
        }
        config.put("labels", FreeTextSearch.escape(structure.keySet()));
        for (Map.Entry<String, List<String>> entry : structure.entrySet()) {
            config.put("keysForLabel:" + FreeTextSearch.escape(entry.getKey()), FreeTextSearch.escape((Collection<String>)entry.getValue()));
        }
    }

    private Executor executor() {
        return Pools.DEFAULT;
    }

    static Analyzer analyzer() {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                WhitespaceTokenizer source = new WhitespaceTokenizer();
                LowerCaseFilter filter = new LowerCaseFilter((TokenStream)source);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
            }

            public String toString() {
                return "LOWER_CASE_WHITESPACE_ANALYZER";
            }
        };
    }

    private static String escape(Collection<String> keys) {
        StringBuilder result = new StringBuilder();
        for (String key : keys) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(FreeTextSearch.escape(key));
        }
        return result.toString();
    }

    private static String escape(String key) {
        return key.replace("$", "$$").replace(":", "$");
    }

    private static /* synthetic */ Counter lambda$populate$1(LabelProperty x) {
        return new Counter();
    }

    private static class Counter {
        long count;

        private Counter() {
        }
    }

    private static class LabelProperty {
        private final String label;
        private final String property;

        LabelProperty(String label, String property) {
            this.label = label;
            this.property = property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelProperty that = (LabelProperty)o;
            return Objects.equals(this.label, that.label) && Objects.equals(this.property, that.property);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.property);
        }

        IndexStats stats(Counter counter) {
            return new IndexStats(this.label, this.property, counter.count);
        }
    }

    public static class IndexStats {
        public final String label;
        public final String property;
        public final long nodeCount;

        private IndexStats(String label, String property, long nodeCount) {
            this.label = label;
            this.property = property;
            this.nodeCount = nodeCount;
        }
    }
}

